/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.HistogramDescriptor;
import javax.media.jai.operator.MeanDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final boolean ROI_USED = Boolean.getBoolean("JAI.Ext.ROIUsed");
    private static final int STATISTIC = Integer.getInteger("JAI.Ext.Statistic", 0);
    private static RenderedImage testImage;
    private static Range rangeNDByte;
    private static Range rangeNDUSHort;
    private static Range rangeNDShort;
    private static Range rangeNDInteger;
    private static Range rangeNDFloat;
    private static Range rangeNDDouble;
    private static int xPeriod;
    private static int yPeriod;
    private static Statistics.StatsType[] arrayStats;
    private static int[] bands;
    private static ROI roi;
    private static int[] numBins;
    private static double[] maxBounds;
    private static double[] minBounds;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        switch (TEST_SELECTOR) {
            case 0: {
                testImage = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
                break;
            }
            case 1: {
                testImage = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false);
                break;
            }
            case 2: {
                testImage = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
                break;
            }
            case 3: {
                testImage = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
                break;
            }
            case 4: {
                testImage = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false);
                break;
            }
            case 5: {
                testImage = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
        if (RANGE_USED && !OLD_DESCRIPTOR) {
            switch (TEST_SELECTOR) {
                case 0: {
                    rangeNDByte = RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true);
                    break;
                }
                case 1: {
                    rangeNDUSHort = RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true);
                    break;
                }
                case 2: {
                    rangeNDShort = RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true);
                    break;
                }
                case 3: {
                    rangeNDInteger = RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true);
                    break;
                }
                case 4: {
                    rangeNDFloat = RangeFactory.create((float)noDataF, (boolean)true, (float)noDataF, (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    rangeNDDouble = RangeFactory.create((double)noDataD, (boolean)true, (double)noDataD, (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        if (ROI_USED) {
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
            roi = new ROIShape((Shape)rect);
        } else {
            roi = null;
        }
        if (STATISTIC == 0) {
            arrayStats = new Statistics.StatsType[]{Statistics.StatsType.MEAN};
        } else if (STATISTIC == 1) {
            arrayStats = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
        } else if (STATISTIC == 2) {
            arrayStats = new Statistics.StatsType[]{Statistics.StatsType.HISTOGRAM};
        }
        bands = new int[]{0, 1, 2};
        xPeriod = 1;
        yPeriod = 1;
        numBins = new int[]{5};
        maxBounds = new double[]{3.0};
        minBounds = new double[]{-3.0};
    }

    @Test
    public void testStatsDescriptor() {
        int[] numBinsTest = null;
        double[] maxBoundsTest = null;
        double[] minBoundsTest = null;
        String stat = "";
        if (STATISTIC == 0) {
            stat = stat + "Mean";
        } else if (STATISTIC == 1) {
            stat = stat + "Extrema";
        } else if (STATISTIC == 2) {
            stat = stat + "Histogram";
            numBinsTest = numBins;
            maxBoundsTest = maxBounds;
            minBoundsTest = minBounds;
        }
        Range rangeND = null;
        int dataType = TEST_SELECTOR;
        String description = "\n ";
        String propertyName = "";
        if (OLD_DESCRIPTOR) {
            propertyName = propertyName + stat;
            description = "Old " + stat;
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            propertyName = propertyName + "JAI-EXT.stats";
            description = "New " + stat;
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            if (RANGE_USED) {
                switch (dataType) {
                    case 0: {
                        rangeND = rangeNDByte;
                        break;
                    }
                    case 1: {
                        rangeND = rangeNDUSHort;
                        break;
                    }
                    case 2: {
                        rangeND = rangeNDShort;
                        break;
                    }
                    case 3: {
                        rangeND = rangeNDInteger;
                        break;
                    }
                    case 4: {
                        rangeND = rangeNDFloat;
                        break;
                    }
                    case 5: {
                        rangeND = rangeNDDouble;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
        }
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageStats = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                if (STATISTIC == 0) {
                    imageStats = MeanDescriptor.create((RenderedImage)testImage, (ROI)roi, (Integer)xPeriod, (Integer)yPeriod, null);
                } else if (STATISTIC == 1) {
                    imageStats = ExtremaDescriptor.create((RenderedImage)testImage, (ROI)roi, (Integer)xPeriod, (Integer)yPeriod, (Boolean)false, (Integer)1, null);
                } else if (STATISTIC == 2) {
                    imageStats = HistogramDescriptor.create((RenderedImage)testImage, (ROI)roi, (Integer)xPeriod, (Integer)yPeriod, (int[])numBinsTest, (double[])minBoundsTest, (double[])maxBoundsTest, null);
                }
            } else {
                imageStats = StatisticsDescriptor.create((RenderedImage)testImage, (int)xPeriod, (int)yPeriod, (ROI)roi, (Range)rangeND, (boolean)false, (int[])bands, (Statistics.StatsType[])arrayStats, (double[])minBoundsTest, (double[])maxBoundsTest, (int[])numBinsTest, null);
            }
            long start = System.nanoTime();
            imageStats.getProperty(propertyName);
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageStats instanceof RenderedOp) {
            imageStats.dispose();
        }
    }
}

