/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.interpolators;

import com.sun.media.jai.util.Rational;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import junit.framework.TestCase;
import org.junit.Test;

public class InterpTest
extends TestCase {
    public static final int DEFAULT_SUBSAMPLE_BITS = 8;
    public static final int DEFAULT_PRECISION_BITS = 8;
    public static float DEFAULT_WIDTH = 512.0f;
    public static float DEFAULT_HEIGHT = 512.0f;
    public static final double DEFAULT_DELTA = 1.5;
    public static boolean DEFAULT_INITIAL_SETUP = false;
    private boolean initialSetup = DEFAULT_INITIAL_SETUP;
    private RenderedImage[] testImages;
    private double noData;
    private int posy;
    private int posx;
    private int posYroi;
    private RasterAccessor[] src;
    private RasterAccessor roiAccessor;
    private Rectangle roiBounds;
    private RandomIter roiIter;
    private Number[][] roiDataArray;
    private Number[] fracvalues = new Number[2];
    private Number[] fracvaluesFloat = new Number[2];
    private float one;
    private int shift2;
    private int round2;
    private int subsampleBits = 8;
    private int precisionBits = 8;
    private int destinationNoData;

    @Test
    public void testInterpolatorNearestNew() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.nearestMethod(dataType, false, false);
        dataType = 1;
        this.nearestMethod(dataType, false, false);
        dataType = 2;
        this.nearestMethod(dataType, false, false);
        dataType = 3;
        this.nearestMethod(dataType, false, false);
        dataType = 4;
        this.nearestMethod(dataType, false, false);
        dataType = 5;
        this.nearestMethod(dataType, false, false);
    }

    @Test
    public void testInterpolatorNearestNewROIBounds() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.nearestMethod(dataType, true, false);
        dataType = 1;
        this.nearestMethod(dataType, true, false);
        dataType = 2;
        this.nearestMethod(dataType, true, false);
        dataType = 3;
        this.nearestMethod(dataType, true, false);
        dataType = 4;
        this.nearestMethod(dataType, true, false);
        dataType = 5;
        this.nearestMethod(dataType, true, false);
    }

    @Test
    public void testInterpolatorNearestNewROIAccessor() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.nearestMethod(dataType, true, true);
        dataType = 1;
        this.nearestMethod(dataType, true, true);
        dataType = 2;
        this.nearestMethod(dataType, true, true);
        dataType = 3;
        this.nearestMethod(dataType, true, true);
        dataType = 4;
        this.nearestMethod(dataType, true, true);
        dataType = 5;
        this.nearestMethod(dataType, true, true);
    }

    @Test
    public void testInterpolatorBilinearNew() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, false, false, true);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, false, false, true);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, false, false, true);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, false, false, true);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, false, false, true);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, false, false, true);
    }

    @Test
    public void testInterpolatorBilinearNewROIBounds() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, true, false, true);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, true, false, true);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, true, false, true);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, true, false, true);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, true, false, true);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, true, false, true);
    }

    @Test
    public void testInterpolatorBilinearNewROIAccessor() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, true, true, true);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, true, true, true);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, true, true, true);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, true, true, true);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, true, true, true);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, true, true, true);
    }

    @Test
    public void testInterpolatorBicubicNew() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, false, false, false);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, false, false, false);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, false, false, false);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, false, false, false);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, false, false, false);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, false, false, false);
    }

    @Test
    public void testInterpolatorBicubicNewROIBounds() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, true, false, false);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, true, false, false);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, true, false, false);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, true, false, false);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, true, false, false);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, true, false, false);
    }

    @Test
    public void testInterpolatorBicubicNewROIAccessor() {
        if (!this.initialSetup) {
            this.initialSetup();
            this.initialSetup = true;
        }
        int dataType = 0;
        this.bilinearBicubicMethod(dataType, true, true, false);
        dataType = 1;
        this.bilinearBicubicMethod(dataType, true, true, false);
        dataType = 2;
        this.bilinearBicubicMethod(dataType, true, true, false);
        dataType = 3;
        this.bilinearBicubicMethod(dataType, true, true, false);
        dataType = 4;
        this.bilinearBicubicMethod(dataType, true, true, false);
        dataType = 5;
        this.bilinearBicubicMethod(dataType, true, true, false);
    }

    private void nearestMethod(int dataType, boolean roiUsed, boolean useROIAccessor) {
        InterpolationNearest interpN = null;
        Number expected = null;
        Number testInterpolationValue = null;
        switch (dataType) {
            case 0: {
                expected = this.src[dataType].getByteDataArray(0)[this.posx + this.posy];
                break;
            }
            case 1: 
            case 2: {
                expected = this.src[dataType].getShortDataArray(0)[this.posx + this.posy];
                break;
            }
            case 3: {
                expected = this.src[dataType].getIntDataArray(0)[this.posx + this.posy];
                break;
            }
            case 4: {
                expected = Float.valueOf(this.src[dataType].getFloatDataArray(0)[this.posx + this.posy]);
                break;
            }
            case 5: {
                expected = this.src[dataType].getDoubleDataArray(0)[this.posx + this.posy];
            }
        }
        if (roiUsed) {
            if (useROIAccessor) {
                int windex = this.posx + this.posYroi;
                switch (dataType) {
                    case 0: {
                        byte wB = (byte)(windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].byteValue() & 0xFF : 0);
                        if (wB != 0) break;
                        expected = (byte)this.destinationNoData;
                        break;
                    }
                    case 1: {
                        short wUS = (short)(windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].shortValue() & 0xFFFF : 0);
                        if (wUS != 0) break;
                        expected = (short)this.destinationNoData;
                        break;
                    }
                    case 2: {
                        short wS;
                        short s = wS = windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].shortValue() : (short)0;
                        if (wS != 0) break;
                        expected = (short)this.destinationNoData;
                        break;
                    }
                    case 3: {
                        int wI;
                        int n = wI = windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].intValue() : 0;
                        if (wI != 0) break;
                        expected = this.destinationNoData;
                        break;
                    }
                    case 4: {
                        float wF;
                        float f = wF = windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].floatValue() : 0.0f;
                        if (wF != 0.0f) break;
                        expected = Float.valueOf(this.destinationNoData);
                        break;
                    }
                    case 5: {
                        double wD;
                        double d = wD = windex < this.roiDataArray[dataType].length ? this.roiDataArray[dataType][windex].doubleValue() : 0.0;
                        if (wD != 0.0) break;
                        expected = this.destinationNoData;
                    }
                }
                interpN = new InterpolationNearest(null, useROIAccessor, (double)this.destinationNoData, dataType);
                testInterpolationValue = interpN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, Integer.valueOf(this.posYroi), this.roiAccessor, false);
            } else {
                int y0;
                int x0 = this.src[dataType].getX() + this.posx / this.src[dataType].getPixelStride();
                if (!this.roiBounds.contains(x0, y0 = this.src[dataType].getY() + (this.posy - this.src[dataType].getBandOffset(0)) / this.src[dataType].getScanlineStride())) {
                    expected = this.destinationNoData;
                }
                interpN = new InterpolationNearest(null, useROIAccessor, (double)this.destinationNoData, dataType);
                interpN.setROIdata(this.roiBounds, this.roiIter);
                testInterpolationValue = interpN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, null, null, false);
            }
        } else {
            switch (dataType) {
                case 0: {
                    Range noDataRangeB = RangeFactory.create((byte)((byte)this.noData), (boolean)true, (byte)((byte)this.noData), (boolean)true);
                    if (noDataRangeB.contains(expected.byteValue())) {
                        expected = this.destinationNoData;
                    }
                    interpN = new InterpolationNearest(noDataRangeB, useROIAccessor, (double)this.destinationNoData, dataType);
                    break;
                }
                case 1: 
                case 2: {
                    Range noDataRangeS = RangeFactory.create((short)((short)this.noData), (boolean)true, (short)((short)this.noData), (boolean)true);
                    if (noDataRangeS.contains(expected.shortValue())) {
                        expected = this.destinationNoData;
                    }
                    interpN = new InterpolationNearest(noDataRangeS, useROIAccessor, (double)this.destinationNoData, dataType);
                    break;
                }
                case 3: {
                    Range noDataRangeI = RangeFactory.create((int)((int)this.noData), (boolean)true, (int)((int)this.noData), (boolean)true);
                    if (noDataRangeI.contains(expected.intValue())) {
                        expected = this.destinationNoData;
                    }
                    interpN = new InterpolationNearest(noDataRangeI, useROIAccessor, (double)this.destinationNoData, dataType);
                    break;
                }
                case 4: {
                    Range noDataRangeF = RangeFactory.create((float)((float)this.noData), (boolean)true, (float)((float)this.noData), (boolean)true, (boolean)true);
                    if (noDataRangeF.contains(expected.floatValue())) {
                        expected = this.destinationNoData;
                    }
                    interpN = new InterpolationNearest(noDataRangeF, useROIAccessor, (double)this.destinationNoData, dataType);
                    break;
                }
                case 5: {
                    Range noDataRangeD = RangeFactory.create((double)this.noData, (boolean)true, (double)this.noData, (boolean)true, (boolean)true);
                    if (noDataRangeD.contains(expected.doubleValue())) {
                        expected = this.destinationNoData;
                    }
                    interpN = new InterpolationNearest(noDataRangeD, useROIAccessor, (double)this.destinationNoData, dataType);
                }
            }
            testInterpolationValue = interpN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, null, null, false);
        }
        this.assertEquality(dataType, expected, testInterpolationValue);
    }

    private Number bicubicCalculation(int dataType, Number[][] pixelArray, int[][] weightArray, InterpolationBicubic interpBN) {
        int[] dataHi = interpBN.getHorizontalTableData();
        int[] dataVi = interpBN.getVerticalTableData();
        float[] dataHf = interpBN.getHorizontalTableDataFloat();
        float[] dataVf = interpBN.getVerticalTableDataFloat();
        double[] dataHd = interpBN.getHorizontalTableDataDouble();
        double[] dataVd = interpBN.getVerticalTableDataDouble();
        int round = 1 << this.precisionBits - 1;
        int xfrac = this.fracvalues[0].intValue();
        int yfrac = this.fracvalues[1].intValue();
        int offsetX = 4 * xfrac;
        int offsetY = 4 * yfrac;
        long[] rowSum = new long[4];
        float[] rowSumF = new float[4];
        double[] rowSumD = new double[4];
        int temp = 0;
        float tempf = 0.0f;
        double tempd = 0.0;
        boolean[] weight0 = new boolean[4];
        for (int ii = 0; ii < 4; ++ii) {
            int[][] lineArray = new int[][]{weightArray[ii]};
            weight0[ii] = this.sumWeight(lineArray) == 0;
        }
        long[] valueArray = null;
        float[] valueArrayF = null;
        double[] valueArrayD = null;
        int value_ = 0;
        int value0 = 0;
        int value1 = 0;
        int value2 = 0;
        float value_f = 0.0f;
        float value0f = 0.0f;
        float value1f = 0.0f;
        float value2f = 0.0f;
        double value_d = 0.0;
        double value0d = 0.0;
        double value1d = 0.0;
        double value2d = 0.0;
        for (int k = 0; k < rowSum.length; ++k) {
            rowSum[k] = 0L;
            rowSumF[k] = 0.0f;
            rowSumD[k] = 0.0;
            switch (dataType) {
                case 0: {
                    value_ = pixelArray[k][0].byteValue() & 0xFF;
                    value0 = pixelArray[k][1].byteValue() & 0xFF;
                    value1 = pixelArray[k][2].byteValue() & 0xFF;
                    value2 = pixelArray[k][3].byteValue() & 0xFF;
                    valueArray = this.bicubicInpainting(value_, value0, value1, value2, weightArray[k], null);
                    break;
                }
                case 1: {
                    value_ = pixelArray[k][0].shortValue() & 0xFFFF;
                    value0 = pixelArray[k][1].shortValue() & 0xFFFF;
                    value1 = pixelArray[k][2].shortValue() & 0xFFFF;
                    value2 = pixelArray[k][3].shortValue() & 0xFFFF;
                    valueArray = this.bicubicInpainting(value_, value0, value1, value2, weightArray[k], null);
                    break;
                }
                case 2: {
                    value_ = pixelArray[k][0].shortValue();
                    value0 = pixelArray[k][1].shortValue();
                    value1 = pixelArray[k][2].shortValue();
                    value2 = pixelArray[k][3].shortValue();
                    valueArray = this.bicubicInpainting(value_, value0, value1, value2, weightArray[k], null);
                    break;
                }
                case 3: {
                    value_ = pixelArray[k][0].intValue();
                    value0 = pixelArray[k][1].intValue();
                    value1 = pixelArray[k][2].intValue();
                    value2 = pixelArray[k][3].intValue();
                    valueArray = this.bicubicInpainting(value_, value0, value1, value2, weightArray[k], null);
                    break;
                }
                case 4: {
                    value_f = pixelArray[k][0].floatValue();
                    value0f = pixelArray[k][1].floatValue();
                    value1f = pixelArray[k][2].floatValue();
                    value2f = pixelArray[k][3].floatValue();
                    valueArrayF = this.bicubicInpaintingFloat(value_f, value0f, value1f, value2f, weightArray[k], null);
                    break;
                }
                case 5: {
                    value_d = pixelArray[k][0].doubleValue();
                    value0d = pixelArray[k][1].doubleValue();
                    value1d = pixelArray[k][2].doubleValue();
                    value2d = pixelArray[k][3].doubleValue();
                    valueArrayD = this.bicubicInpaintingDouble(value_d, value0d, value1d, value2d, weightArray[k], null);
                }
            }
            block33: for (int h = 0; h < rowSum.length; ++h) {
                switch (dataType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int n = k;
                        rowSum[n] = rowSum[n] + (long)dataHi[offsetX + h] * valueArray[h];
                        continue block33;
                    }
                    case 4: {
                        int n = k;
                        rowSumF[n] = rowSumF[n] + dataHf[offsetX + h] * valueArrayF[h];
                        continue block33;
                    }
                    case 5: {
                        int n = k;
                        rowSumD[n] = rowSumD[n] + dataHd[offsetX + h] * valueArrayD[h];
                    }
                }
            }
            rowSum[k] = rowSum[k] + (long)round >> this.precisionBits;
        }
        long[] valueArrayV = null;
        float[] valueArrayVF = null;
        double[] valueArrayVD = null;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                valueArrayV = this.bicubicInpainting(rowSum[0], rowSum[1], rowSum[2], rowSum[3], null, weight0);
                break;
            }
            case 4: {
                valueArrayVF = this.bicubicInpaintingFloat(rowSumF[0], rowSumF[1], rowSumF[2], rowSumF[3], null, weight0);
                break;
            }
            case 5: {
                valueArrayVD = this.bicubicInpaintingDouble(rowSumD[0], rowSumD[1], rowSumD[2], rowSumD[3], null, weight0);
            }
        }
        block34: for (int k = 0; k < rowSum.length; ++k) {
            switch (dataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    temp = (int)((long)temp + (long)dataVi[offsetY + k] * valueArrayV[k]);
                    continue block34;
                }
                case 4: {
                    tempf += dataVf[offsetY + k] * valueArrayVF[k];
                    continue block34;
                }
                case 5: {
                    tempd += dataVd[offsetY + k] * valueArrayVD[k];
                }
            }
        }
        temp = temp + round >> this.precisionBits;
        switch (dataType) {
            case 0: {
                if (temp > 255) {
                    temp = 255;
                } else if (temp < 0) {
                    temp = 0;
                }
                return temp;
            }
            case 1: {
                if (temp > 65536) {
                    temp = 65536;
                } else if (temp < 0) {
                    temp = 0;
                }
                return temp;
            }
            case 2: {
                if (temp > Short.MAX_VALUE) {
                    temp = Short.MAX_VALUE;
                } else if (temp < Short.MIN_VALUE) {
                    temp = Short.MIN_VALUE;
                }
                return temp;
            }
            case 3: {
                return temp;
            }
            case 4: {
                if (tempf > Float.MAX_VALUE) {
                    tempf = Float.MAX_VALUE;
                } else if (tempf < -3.4028235E38f) {
                    tempf = -3.4028235E38f;
                }
                return Float.valueOf(tempf);
            }
            case 5: {
                return tempd;
            }
        }
        return 0;
    }

    private long[] bicubicInpainting(long s_, long s0, long s1, long s2, int[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new int[]{s_ == 0L && weight0[0] ? 0 : 1, s0 == 0L && weight0[1] ? 0 : 1, s1 == 0L && weight0[2] ? 0 : 1, s2 == 0L && weight0[3] ? 0 : 1};
        }
        int[][] array = new int[][]{weightArray};
        long[] emptyArray = new long[4];
        int sum = this.sumWeight(array);
        long meanValue = 0L;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                long validData = 0L;
                validData = weightArray[0] == 1 ? s_ : (weightArray[1] == 1 ? s0 : (weightArray[2] == 1 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0 && weightArray[1] == 0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2L;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[3] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0 && weightArray[2] == 0) {
                    meanValue = (s_ + s2) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0 && weightArray[3] == 0) {
                    meanValue = (s_ + s1) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0) {
                    meanValue = (s_ + s1) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2L;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private float[] bicubicInpaintingFloat(float s_, float s0, float s1, float s2, int[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new int[]{s_ == 0.0f && weight0[0] ? 0 : 1, s0 == 0.0f && weight0[1] ? 0 : 1, s1 == 0.0f && weight0[2] ? 0 : 1, s2 == 0.0f && weight0[3] ? 0 : 1};
        }
        int[][] array = new int[][]{weightArray};
        float[] emptyArray = new float[4];
        int sum = this.sumWeight(array);
        float meanValue = 0.0f;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                float validData = 0.0f;
                validData = weightArray[0] == 1 ? s_ : (weightArray[1] == 1 ? s0 : (weightArray[2] == 1 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0 && weightArray[1] == 0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2.0f;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[3] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0 && weightArray[2] == 0) {
                    meanValue = (s_ + s2) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0 && weightArray[3] == 0) {
                    meanValue = (s_ + s1) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0) {
                    meanValue = (s_ + s1) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2.0f;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private double[] bicubicInpaintingDouble(double s_, double s0, double s1, double s2, int[] weightArray, boolean[] weight0) {
        if (weightArray == null) {
            weightArray = new int[]{s_ == 0.0 && weight0[0] ? 0 : 1, s0 == 0.0 && weight0[1] ? 0 : 1, s1 == 0.0 && weight0[2] ? 0 : 1, s2 == 0.0 && weight0[3] ? 0 : 1};
        }
        int[][] array = new int[][]{weightArray};
        double[] emptyArray = new double[4];
        int sum = this.sumWeight(array);
        double meanValue = 0.0;
        switch (sum) {
            case 0: {
                return emptyArray;
            }
            case 1: {
                double validData = 0.0;
                validData = weightArray[0] == 1 ? s_ : (weightArray[1] == 1 ? s0 : (weightArray[2] == 1 ? s1 : s2));
                emptyArray[0] = validData;
                emptyArray[1] = validData;
                emptyArray[2] = validData;
                emptyArray[3] = validData;
                return emptyArray;
            }
            case 2: {
                if (weightArray[0] == 0 && weightArray[1] == 0) {
                    emptyArray[0] = s1;
                    emptyArray[1] = s1;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2.0;
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[0] == 0 && weightArray[3] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else if (weightArray[1] == 0 && weightArray[2] == 0) {
                    meanValue = (s_ + s2) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0 && weightArray[3] == 0) {
                    meanValue = (s_ + s1) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s0;
                    emptyArray[3] = s0;
                }
                return emptyArray;
            }
            case 3: {
                if (weightArray[0] == 0) {
                    emptyArray[0] = s0;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[1] == 0) {
                    meanValue = (s_ + s1) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = meanValue;
                    emptyArray[2] = s1;
                    emptyArray[3] = s2;
                } else if (weightArray[2] == 0) {
                    meanValue = (s0 + s2) / 2.0;
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = meanValue;
                    emptyArray[3] = s2;
                } else {
                    emptyArray[0] = s_;
                    emptyArray[1] = s0;
                    emptyArray[2] = s1;
                    emptyArray[3] = s1;
                }
                return emptyArray;
            }
            case 4: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                return emptyArray;
            }
        }
        throw new IllegalArgumentException("The input array cannot have more than 4 pixels");
    }

    private void bilinearBicubicMethod(int dataType, boolean roiUsed, boolean useROIAccessor, boolean bilinearUsed) {
        InterpolationBilinear interpB = null;
        InterpolationBicubic interpBN = null;
        Number expected = 0;
        Number testInterpolationValue = null;
        Number[][] pixelArray = this.pixelCalculation(bilinearUsed, dataType);
        int sum = 0;
        int[][] weightArray = null;
        weightArray = bilinearUsed ? new int[2][2] : new int[4][4];
        if (roiUsed) {
            if (useROIAccessor) {
                if (bilinearUsed) {
                    interpB = new InterpolationBilinear(this.subsampleBits, null, true, (double)this.destinationNoData, dataType);
                    testInterpolationValue = interpB.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, Integer.valueOf(this.posYroi), this.roiAccessor, false);
                } else {
                    interpBN = new InterpolationBicubic(this.subsampleBits, null, true, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    testInterpolationValue = interpBN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, Integer.valueOf(this.posYroi), this.roiAccessor, false);
                }
                weightArray = this.roiAccessorCheck(dataType, pixelArray, weightArray, bilinearUsed);
            } else {
                if (bilinearUsed) {
                    interpB = new InterpolationBilinear(this.subsampleBits, null, false, (double)this.destinationNoData, dataType);
                    interpB.setROIdata(this.roiBounds, this.roiIter);
                    testInterpolationValue = interpB.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, null, null, false);
                } else {
                    interpBN = new InterpolationBicubic(this.subsampleBits, null, false, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    interpBN.setROIdata(this.roiBounds, this.roiIter);
                    testInterpolationValue = interpBN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, null, null, false);
                }
                weightArray = this.roiBoundCheck(dataType, pixelArray, weightArray, bilinearUsed);
            }
            sum = this.sumWeight(weightArray);
            if (sum > 0) {
                for (int i = 0; i < weightArray.length; ++i) {
                    for (int j = 0; j < weightArray.length; ++j) {
                        weightArray[i][j] = 1;
                    }
                }
            }
        } else {
            switch (dataType) {
                case 0: {
                    Range noDataRangeB = RangeFactory.create((byte)((byte)this.noData), (boolean)true, (byte)((byte)this.noData), (boolean)true);
                    if (bilinearUsed) {
                        interpB = new InterpolationBilinear(8, noDataRangeB, useROIAccessor, (double)this.destinationNoData, dataType);
                    } else {
                        interpBN = new InterpolationBicubic(8, noDataRangeB, useROIAccessor, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    }
                    weightArray = this.noDataCheck(dataType, pixelArray, weightArray, noDataRangeB);
                    break;
                }
                case 1: 
                case 2: {
                    Range noDataRangeS = RangeFactory.create((short)((short)this.noData), (boolean)true, (short)((short)this.noData), (boolean)true);
                    interpB = new InterpolationBilinear(8, noDataRangeS, useROIAccessor, (double)this.destinationNoData, dataType);
                    if (bilinearUsed) {
                        interpB = new InterpolationBilinear(8, noDataRangeS, useROIAccessor, (double)this.destinationNoData, dataType);
                    } else {
                        interpBN = new InterpolationBicubic(8, noDataRangeS, useROIAccessor, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    }
                    weightArray = this.noDataCheck(dataType, pixelArray, weightArray, noDataRangeS);
                    break;
                }
                case 3: {
                    Range noDataRangeI = RangeFactory.create((int)((int)this.noData), (boolean)true, (int)((int)this.noData), (boolean)true);
                    interpB = new InterpolationBilinear(8, noDataRangeI, useROIAccessor, (double)this.destinationNoData, dataType);
                    if (bilinearUsed) {
                        interpB = new InterpolationBilinear(8, noDataRangeI, useROIAccessor, (double)this.destinationNoData, dataType);
                    } else {
                        interpBN = new InterpolationBicubic(8, noDataRangeI, useROIAccessor, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    }
                    weightArray = this.noDataCheck(dataType, pixelArray, weightArray, noDataRangeI);
                    break;
                }
                case 4: {
                    Range noDataRangeF = RangeFactory.create((float)((float)this.noData), (boolean)true, (float)((float)this.noData), (boolean)true, (boolean)true);
                    interpB = new InterpolationBilinear(8, noDataRangeF, useROIAccessor, (double)this.destinationNoData, dataType);
                    if (bilinearUsed) {
                        interpB = new InterpolationBilinear(8, noDataRangeF, useROIAccessor, (double)this.destinationNoData, dataType);
                    } else {
                        interpBN = new InterpolationBicubic(8, noDataRangeF, useROIAccessor, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    }
                    weightArray = this.noDataCheck(dataType, pixelArray, weightArray, noDataRangeF);
                    break;
                }
                case 5: {
                    Range noDataRangeD = RangeFactory.create((double)this.noData, (boolean)true, (double)this.noData, (boolean)true, (boolean)true);
                    interpB = new InterpolationBilinear(8, noDataRangeD, useROIAccessor, (double)this.destinationNoData, dataType);
                    if (bilinearUsed) {
                        interpB = new InterpolationBilinear(8, noDataRangeD, useROIAccessor, (double)this.destinationNoData, dataType);
                    } else {
                        interpBN = new InterpolationBicubic(8, noDataRangeD, useROIAccessor, (double)this.destinationNoData, dataType, false, this.precisionBits);
                    }
                    weightArray = this.noDataCheck(dataType, pixelArray, weightArray, noDataRangeD);
                }
            }
            testInterpolationValue = bilinearUsed ? (Number)interpB.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, null, null, false) : (Number)interpBN.interpolate(this.src[dataType], 0, 1, this.posx, this.posy, this.fracvalues, null, null, false);
        }
        expected = (sum = this.sumWeight(weightArray)) == 0 ? (Number)((byte)this.destinationNoData) : (Number)(bilinearUsed ? (Number)(dataType < 4 ? (Number)this.computeValue(dataType, pixelArray[0][0].intValue(), pixelArray[0][1].intValue(), pixelArray[1][0].intValue(), pixelArray[1][1].intValue(), weightArray[0][0], weightArray[0][1], weightArray[1][0], weightArray[1][1], this.fracvalues[0].intValue(), this.fracvalues[1].intValue()) : (Number)this.computeValueDouble(dataType, pixelArray[0][0].doubleValue(), pixelArray[0][1].doubleValue(), pixelArray[1][0].doubleValue(), pixelArray[1][1].doubleValue(), weightArray[0][0], weightArray[0][1], weightArray[1][0], weightArray[1][1], this.fracvalues[0].intValue(), this.fracvalues[1].intValue())) : (Number)this.bicubicCalculation(dataType, pixelArray, weightArray, interpBN));
        this.assertEquality(dataType, expected, testInterpolationValue);
    }

    public void assertEquality(int dataType, Number expected, Number testInterpolationValue) {
        switch (dataType) {
            case 0: {
                InterpTest.assertEquals((String)"These values must be equal", (byte)expected.byteValue(), (byte)testInterpolationValue.byteValue());
                break;
            }
            case 1: 
            case 2: {
                InterpTest.assertEquals((String)"These values must be equal", (short)expected.shortValue(), (short)testInterpolationValue.shortValue());
                break;
            }
            case 3: {
                InterpTest.assertEquals((String)"These values must be equal", (int)expected.intValue(), (int)testInterpolationValue.intValue());
                break;
            }
            case 4: {
                InterpTest.assertEquals((String)"These values must be equal", (double)expected.floatValue(), (double)testInterpolationValue.floatValue(), (double)1.5);
                break;
            }
            case 5: {
                InterpTest.assertEquals((String)"These values must be equal", (double)expected.doubleValue(), (double)testInterpolationValue.doubleValue(), (double)1.5);
            }
        }
    }

    public int[][] noDataCheck(int dataType, Number[][] pixelArray, int[][] weightArray, Range noDataRange) {
        for (int i = 0; i < pixelArray.length; ++i) {
            block9: for (int j = 0; j < pixelArray.length; ++j) {
                switch (dataType) {
                    case 0: {
                        if (noDataRange.contains(pixelArray[i][j].byteValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    case 1: {
                        if (noDataRange.contains(pixelArray[i][j].shortValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    case 2: {
                        if (noDataRange.contains(pixelArray[i][j].shortValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    case 3: {
                        if (noDataRange.contains(pixelArray[i][j].intValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    case 4: {
                        if (noDataRange.contains(pixelArray[i][j].floatValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    case 5: {
                        if (noDataRange.contains(pixelArray[i][j].doubleValue())) {
                            weightArray[i][j] = 0;
                            continue block9;
                        }
                        weightArray[i][j] = 1;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
        }
        return weightArray;
    }

    public int[][] roiBoundCheck(int dataType, Number[][] pixelArray, int[][] weightArray, boolean bilinearUsed) {
        int y0;
        int x0 = this.src[dataType].getX() + this.posx / this.src[dataType].getPixelStride();
        if (this.roiBounds.contains(x0, y0 = this.src[dataType].getY() + (this.posy - this.src[dataType].getBandOffset(0)) / this.src[dataType].getScanlineStride())) {
            for (int i = 0; i < pixelArray.length; ++i) {
                for (int j = 0; j < pixelArray.length; ++j) {
                    weightArray[i][j] = bilinearUsed ? this.roiIter.getSample(x0 + j, y0 + i, 0) : this.roiIter.getSample(x0 + (j - 1), y0 + (i - 1), 0);
                }
            }
        }
        return weightArray;
    }

    public int[][] roiAccessorCheck(int dataType, Number[][] pixelArray, int[][] weightArray, boolean bilinearUsed) {
        block7: {
            int j;
            int i;
            int roiDataLength;
            int[][] weightArrayIndex;
            block6: {
                weightArrayIndex = weightArray;
                roiDataLength = this.roiDataArray[dataType].length;
                for (i = 0; i < pixelArray.length; ++i) {
                    for (j = 0; j < pixelArray.length; ++j) {
                        weightArrayIndex[i][j] = bilinearUsed ? this.posx + j + this.posYroi + i * this.roiAccessor.getScanlineStride() : this.posx + (j - 1) + this.posYroi + (i - 1) * this.roiAccessor.getScanlineStride();
                        weightArray[i][j] = weightArrayIndex[i][j] < roiDataLength ? this.roiDataArray[dataType][weightArrayIndex[i][j]].intValue() : 0;
                    }
                }
                if (!bilinearUsed || weightArrayIndex[0][0] <= roiDataLength && this.roiDataArray[dataType][weightArrayIndex[0][0]].intValue() != 0) break block6;
                for (i = 0; i < pixelArray.length; ++i) {
                    for (j = 0; j < pixelArray.length; ++j) {
                        weightArray[i][j] = 0;
                    }
                }
                break block7;
            }
            if (bilinearUsed || weightArrayIndex[1][1] <= roiDataLength && this.roiDataArray[dataType][weightArrayIndex[1][1]].intValue() != 0) break block7;
            for (i = 0; i < pixelArray.length; ++i) {
                for (j = 0; j < pixelArray.length; ++j) {
                    weightArray[i][j] = 0;
                }
            }
        }
        return weightArray;
    }

    public int sumWeight(int[][] weightArray) {
        int sum = 0;
        for (int i = 0; i < weightArray.length; ++i) {
            for (int j = 0; j < weightArray[i].length; ++j) {
                sum += weightArray[i][j];
            }
        }
        return sum;
    }

    private Number[][] pixelCalculation(boolean bilinearUsed, int datatype) {
        int j;
        Number[][] pixelArray = null;
        Number[] srcData = null;
        int srcPixelStride = this.src[datatype].getPixelStride();
        int srcLineStride = this.src[datatype].getScanlineStride();
        switch (datatype) {
            case 0: {
                byte[] srcDataB = this.src[datatype].getByteDataArray(0);
                srcData = new Number[srcDataB.length];
                for (int i = 0; i < srcDataB.length; ++i) {
                    srcData[i] = srcDataB[i];
                }
                break;
            }
            case 1: 
            case 2: {
                short[] srcDataS = this.src[datatype].getShortDataArray(0);
                srcData = new Number[srcDataS.length];
                for (int i = 0; i < srcDataS.length; ++i) {
                    srcData[i] = srcDataS[i];
                }
                break;
            }
            case 3: {
                int[] srcDataI = this.src[datatype].getIntDataArray(0);
                srcData = new Number[srcDataI.length];
                for (int i = 0; i < srcDataI.length; ++i) {
                    srcData[i] = srcDataI[i];
                }
                break;
            }
            case 4: {
                float[] srcDataF = this.src[datatype].getFloatDataArray(0);
                srcData = new Number[srcDataF.length];
                for (int i = 0; i < srcDataF.length; ++i) {
                    srcData[i] = Float.valueOf(srcDataF[i]);
                }
                break;
            }
            case 5: {
                double[] srcDataD = this.src[datatype].getDoubleDataArray(0);
                srcData = new Number[srcDataD.length];
                for (int i = 0; i < srcDataD.length; ++i) {
                    srcData[i] = srcDataD[i];
                }
                break;
            }
        }
        if (bilinearUsed) {
            pixelArray = new Number[2][2];
            for (int i = 0; i < pixelArray.length; ++i) {
                block29: for (j = 0; j < pixelArray.length; ++j) {
                    switch (datatype) {
                        case 0: {
                            pixelArray[i][j] = srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].byteValue() & 0xFF;
                            continue block29;
                        }
                        case 1: {
                            pixelArray[i][j] = srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].shortValue() & 0xFFFF;
                            continue block29;
                        }
                        case 2: {
                            pixelArray[i][j] = srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].shortValue();
                            continue block29;
                        }
                        case 3: {
                            pixelArray[i][j] = srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].intValue();
                            continue block29;
                        }
                        case 4: {
                            pixelArray[i][j] = Float.valueOf(srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].floatValue());
                            continue block29;
                        }
                        case 5: {
                            pixelArray[i][j] = srcData[this.posx + i * srcLineStride + this.posy + j * srcPixelStride].doubleValue();
                            continue block29;
                        }
                    }
                }
            }
        } else {
            pixelArray = new Number[4][4];
            for (int i = 0; i < pixelArray.length; ++i) {
                block31: for (j = 0; j < pixelArray.length; ++j) {
                    switch (datatype) {
                        case 0: {
                            pixelArray[i][j] = srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].byteValue() & 0xFF;
                            continue block31;
                        }
                        case 1: {
                            pixelArray[i][j] = srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].shortValue() & 0xFFFF;
                            continue block31;
                        }
                        case 2: {
                            pixelArray[i][j] = srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].shortValue();
                            continue block31;
                        }
                        case 3: {
                            pixelArray[i][j] = srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].intValue();
                            continue block31;
                        }
                        case 4: {
                            pixelArray[i][j] = Float.valueOf(srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].floatValue());
                            continue block31;
                        }
                        case 5: {
                            pixelArray[i][j] = srcData[this.posx + (i - 1) * srcLineStride + this.posy + (j - 1) * srcPixelStride].doubleValue();
                            continue block31;
                        }
                    }
                }
            }
        }
        return pixelArray;
    }

    private void initialSetup() {
        this.initialSetup = true;
        this.noData = 1.0;
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.destinationNoData = 80;
        this.testImages = new RenderedImage[6];
        Raster[] testRasters = new Raster[this.testImages.length];
        for (int s = 0; s < this.testImages.length; ++s) {
            this.testImages[s] = InterpTest.getSyntheticNotUniformImage(1, s, this.noData);
            RenderedImage temporaryImage = this.testImages[s];
            int minTileX = temporaryImage.getMinTileX();
            int minTileY = temporaryImage.getMinTileY();
            testRasters[s] = temporaryImage.getTile(minTileX, minTileY);
        }
        Raster testRaster = testRasters[0];
        Rectangle srcRect = testRaster.getBounds();
        this.roiBounds = new Rectangle(0, 0, testRaster.getWidth() / 2, testRaster.getHeight() / 2);
        ROIShape roiRect = new ROIShape((Shape)this.roiBounds);
        PlanarImage roiImage = roiRect.getAsImage();
        Raster roiData = roiImage.getExtendedData(testRaster.getBounds(), BorderExtender.createInstance((int)0));
        this.roiIter = RandomIterFactory.create((Raster)roiData, (Rectangle)testRaster.getBounds(), (boolean)false, (boolean)true);
        Raster roiDataAcc = roiImage.getExtendedData(testRaster.getBounds(), BorderExtender.createInstance((int)0));
        this.roiAccessor = new RasterAccessor(roiDataAcc, testRaster.getBounds(), RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{roiImage}, (RenderedImage)roiImage)[0], roiImage.getColorModel());
        this.src = new RasterAccessor[6];
        this.roiDataArray = new Number[this.src.length][];
        block8: for (int z = 0; z < this.src.length; ++z) {
            RenderedImage[] arrayIMG = new RenderedImage[]{this.testImages[z]};
            RasterFormatTag[] formatTags = RasterAccessor.findCompatibleTags((RenderedImage[])arrayIMG, (RenderedImage)this.testImages[z]);
            this.src[z] = new RasterAccessor(testRasters[z], srcRect, formatTags[0], this.testImages[z].getColorModel());
            byte[] roiDataArrayByte = this.roiAccessor.getByteDataArray(0);
            this.roiDataArray[z] = new Number[roiDataArrayByte.length];
            switch (z) {
                case 0: {
                    int i;
                    for (i = 0; i < roiDataArrayByte.length; ++i) {
                        this.roiDataArray[z][i] = roiDataArrayByte[i];
                    }
                    continue block8;
                }
                case 1: 
                case 2: {
                    int i;
                    for (i = 0; i < roiDataArrayByte.length; ++i) {
                        this.roiDataArray[z][i] = (short)roiDataArrayByte[i];
                    }
                    continue block8;
                }
                case 3: {
                    int i;
                    for (i = 0; i < roiDataArrayByte.length; ++i) {
                        this.roiDataArray[z][i] = (int)roiDataArrayByte[i];
                    }
                    continue block8;
                }
                case 4: {
                    int i;
                    for (i = 0; i < roiDataArrayByte.length; ++i) {
                        this.roiDataArray[z][i] = Float.valueOf(roiDataArrayByte[i]);
                    }
                    continue block8;
                }
                case 5: {
                    int i;
                    for (i = 0; i < roiDataArrayByte.length; ++i) {
                        this.roiDataArray[z][i] = (double)roiDataArrayByte[i];
                    }
                    continue block8;
                }
            }
        }
        long sxNum = 1L;
        long sxDenom = 1L;
        long transXRationalDenom = 1L;
        long transXRationalNum = 0L;
        sxNum = sxNum * transXRationalDenom - transXRationalNum * sxDenom;
        sxNum = 2L * sxNum + (sxDenom *= transXRationalDenom);
        sxDenom *= 2L;
        long invScaleXRationalNum = 1L;
        long invScaleXRationalDenom = 4L;
        int srcXInt = Rational.floor((long)(sxNum *= invScaleXRationalNum), (long)(sxDenom *= invScaleXRationalDenom));
        long srcXFrac = sxNum % sxDenom;
        if (srcXInt < 0) {
            srcXFrac = sxDenom + srcXFrac;
        }
        double value = 0.0;
        value = Math.random() > 0.5 ? 0.6 : 0.4;
        long commonXDenom = sxDenom * invScaleXRationalDenom;
        this.posx = ((srcXInt += (int)(value * (double)(srcRect.width - 1) + (double)srcRect.x)) - srcRect.x) * this.src[0].getPixelStride();
        this.fracvalues[0] = (int)((float)srcXFrac / (float)commonXDenom * this.one);
        this.fracvaluesFloat[0] = Float.valueOf((float)srcXFrac / (float)commonXDenom);
        long syNum = 1L;
        long syDenom = 1L;
        long transYRationalDenom = 1L;
        long transYRationalNum = 0L;
        syNum = syNum * transYRationalDenom - transYRationalNum * sxDenom;
        syNum = 2L * syNum + (syDenom *= transYRationalDenom);
        syDenom *= 2L;
        long invScaleYRationalNum = 1L;
        long invScaleYRationalDenom = 4L;
        int srcYInt = Rational.floor((long)(syNum *= invScaleYRationalNum), (long)(syDenom *= invScaleYRationalDenom));
        long srcYFrac = syNum % syDenom;
        if (srcYInt < 0) {
            srcYFrac = syDenom + srcYFrac;
        }
        long commonYDenom = syDenom * invScaleYRationalDenom;
        this.posy = ((srcYInt += (int)(value * (double)(srcRect.height - 1) + (double)srcRect.y)) - srcRect.y) * this.src[0].getScanlineStride() + this.src[0].getBandOffset(0);
        this.posYroi = (srcYInt - srcRect.y) * this.roiAccessor.getScanlineStride();
        this.fracvalues[1] = (int)((float)srcYFrac / (float)commonYDenom * this.one);
        this.fracvaluesFloat[1] = Float.valueOf((float)srcYFrac / (float)commonYDenom);
        if (this.posx < 1) {
            this.posx = 1;
        }
        if (this.posy < this.src[0].getScanlineStride() + this.src[0].getBandOffset(0)) {
            this.posy = this.src[0].getScanlineStride() + this.src[0].getBandOffset(0);
            this.posYroi = this.roiAccessor.getScanlineStride();
        }
        if (this.posx > this.src[0].getScanlineStride() - 3) {
            this.posx = 1;
        }
        if (this.posy > this.src[0].getScanlineStride() * (this.src[0].getHeight() - 3)) {
            this.posy = this.src[0].getScanlineStride() + this.src[0].getBandOffset(0);
            this.posYroi = this.roiAccessor.getScanlineStride();
        }
    }

    private static RenderedImage getSyntheticNotUniformImage(int numBands, int dataType, double noData) {
        ParameterBlock pb = new ParameterBlock();
        pb.add(DEFAULT_WIDTH);
        pb.add(DEFAULT_HEIGHT);
        Double value = noData;
        TiledImage writeImage = null;
        double interval = 0.0;
        switch (dataType) {
            case 0: {
                byte valueByte = ((Number)value).byteValue();
                Byte[] arraybyte = null;
                arraybyte = numBands == 3 ? new Byte[]{valueByte, valueByte, valueByte} : new Byte[]{valueByte};
                pb.add(arraybyte);
                break;
            }
            case 1: {
                short valueUShort = ((Number)value).shortValue();
                Short[] arrayUShort = null;
                arrayUShort = numBands == 3 ? new Short[]{(short)(valueUShort & 0xFFFF), (short)(valueUShort & 0xFFFF), (short)(valueUShort & 0xFFFF)} : new Short[]{(short)(valueUShort & 0xFFFF)};
                pb.add(arrayUShort);
                break;
            }
            case 2: {
                short valueShort = ((Number)value).shortValue();
                Short[] arrayShort = null;
                arrayShort = numBands == 3 ? new Short[]{valueShort, valueShort, valueShort} : new Short[]{valueShort};
                pb.add(arrayShort);
                break;
            }
            case 3: {
                int valueInt = ((Number)value).intValue();
                Integer[] arrayInteger = null;
                arrayInteger = numBands == 3 ? new Integer[]{valueInt, valueInt, valueInt} : new Integer[]{valueInt};
                pb.add(arrayInteger);
                break;
            }
            case 4: {
                float valueFloat = ((Number)value).floatValue();
                Float[] arrayFloat = null;
                arrayFloat = numBands == 3 ? new Float[]{Float.valueOf(valueFloat), Float.valueOf(valueFloat), Float.valueOf(valueFloat)} : new Float[]{Float.valueOf(valueFloat)};
                pb.add(arrayFloat);
                break;
            }
            case 5: {
                double valueDouble = value;
                Double[] arrayDouble = null;
                arrayDouble = numBands == 3 ? new Double[]{valueDouble, valueDouble, valueDouble} : new Double[]{valueDouble};
                pb.add(arrayDouble);
            }
        }
        RenderedOp constant = JAI.create((String)"constant", (ParameterBlock)pb);
        writeImage = new TiledImage((RenderedImage)constant, (int)(DEFAULT_WIDTH / 16.0f), (int)(DEFAULT_HEIGHT / 16.0f));
        Raster firstRaster = writeImage.getTile(writeImage.getMinTileX(), writeImage.getMinTileY());
        int minXpix = firstRaster.getMinX();
        int minYpix = firstRaster.getMinY();
        for (int k = 0; k < numBands; ++k) {
            for (int i = minXpix; i < firstRaster.getWidth() + minXpix; i += 2) {
                block16: for (int j = minYpix; j < firstRaster.getHeight() + minYpix; ++j) {
                    int sI = 0;
                    switch (dataType) {
                        case 0: 
                        case 1: {
                            sI = (int)(Math.random() * interval);
                            writeImage.setSample(i, j, 0, sI);
                            continue block16;
                        }
                        case 2: 
                        case 3: {
                            sI = (int)((Math.random() - 0.5) * interval);
                            writeImage.setSample(i, j, 0, sI);
                            continue block16;
                        }
                        case 4: {
                            float sF = (float)((Math.random() - 0.5) * interval);
                            writeImage.setSample(i, j, 0, sF);
                            continue block16;
                        }
                        case 5: {
                            double s = (Math.random() - 0.5) * interval;
                            writeImage.setSample(i, j, 0, s);
                        }
                    }
                }
            }
        }
        return writeImage;
    }

    private Number computeValue(int dataType, int s00, int s01, int s10, int s11, int w00, int w01, int w10, int w11, int xfrac, int yfrac) {
        boolean s1Long;
        int s0 = 0;
        int s1 = 0;
        int s = 0;
        long s0L = 0L;
        long s1L = 0L;
        int xfracCompl = (int)Math.pow(2.0, this.subsampleBits) - xfrac;
        int yfracCompl = (int)Math.pow(2.0, this.subsampleBits) - yfrac;
        int shift = 29 - this.subsampleBits;
        boolean s0Long = (s00 | s10) >>> shift == 0;
        boolean bl = s1Long = (s01 | s11) >>> shift == 0;
        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
            return this.destinationNoData;
        }
        if (w00 == 0 || w01 == 0 || w10 == 0 || w11 == 0) {
            if (dataType == 3) {
                s0L = w00 == 0 && w01 == 0 ? 0L : (w00 == 0 ? (s1Long ? (long)(-s01 * xfracCompl + (s01 << this.subsampleBits)) : (long)(-s01 * xfracCompl) + ((long)s01 << this.subsampleBits)) : (w01 == 0 ? (s0Long ? (long)(-s00 * xfrac + (s00 << this.subsampleBits)) : (long)(-s00 * xfrac) + ((long)s00 << this.subsampleBits)) : (s0Long ? (s1Long ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : ((long)s01 - (long)s00) * (long)xfrac + (long)(s00 << this.subsampleBits)) : ((long)s01 - (long)s00) * (long)xfrac + ((long)s00 << this.subsampleBits))));
                s1L = w10 == 0 && w11 == 0 ? 0L : (w10 == 0 ? (s1Long ? (long)(-s11 * xfracCompl + (s11 << this.subsampleBits)) : (long)(-s11 * xfracCompl) + ((long)s11 << this.subsampleBits)) : (w11 == 0 ? (s0Long ? (long)(-s10 * xfrac + (s10 << this.subsampleBits)) : (long)(-s10 * xfrac) + ((long)s10 << this.subsampleBits)) : (s0Long ? (s1Long ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : ((long)s11 - (long)s10) * (long)xfrac + (long)(s10 << this.subsampleBits)) : ((long)s11 - (long)s10) * (long)xfrac + ((long)s10 << this.subsampleBits))));
                s = w00 == 0 && w01 == 0 ? (int)(-s1L * (long)yfracCompl + (s1L << this.subsampleBits) + (long)this.round2 >> this.shift2) : (w10 == 0 && w11 == 0 ? (int)(-s0L * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2) : (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2));
            } else {
                s0 = w00 == 0 && w01 == 0 ? 0 : (w00 == 0 ? -s01 * xfracCompl + (s01 << this.subsampleBits) : (w01 == 0 ? -s00 * xfrac + (s00 << this.subsampleBits) : (s01 - s00) * xfrac + (s00 << this.subsampleBits)));
                s1 = w10 == 0 && w11 == 0 ? 0 : (w10 == 0 ? -s11 * xfracCompl + (s11 << this.subsampleBits) : (w11 == 0 ? -s10 * xfrac + (s10 << this.subsampleBits) : (s11 - s10) * xfrac + (s10 << this.subsampleBits)));
                s = w00 == 0 && w01 == 0 ? -s1 * yfracCompl + (s1 << this.subsampleBits) + this.round2 >> this.shift2 : (w10 == 0 && w11 == 0 ? -s0 * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2 : (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2);
            }
        } else if (dataType == 3) {
            if (s0Long) {
                if (s1Long) {
                    s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                    s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                    s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                } else {
                    s0L = ((long)s01 - (long)s00) * (long)xfrac + (long)(s00 << this.subsampleBits);
                    s1L = ((long)s11 - (long)s10) * (long)xfrac + (long)(s10 << this.subsampleBits);
                    s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
            } else {
                s0L = ((long)s01 - (long)s00) * (long)xfrac + ((long)s00 << this.subsampleBits);
                s1L = ((long)s11 - (long)s10) * (long)xfrac + ((long)s10 << this.subsampleBits);
                s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
            }
        } else {
            s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
            s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
            s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
        }
        switch (dataType) {
            case 0: {
                s = (byte)s & 0xFF;
                break;
            }
            case 1: {
                s = (short)s & 0xFFFF;
                break;
            }
            case 2: {
                s = (short)s;
                break;
            }
        }
        return s;
    }

    private Number computeValueDouble(int dataType, double s00, double s01, double s10, double s11, double w00, double w01, double w10, double w11, double xfrac, double yfrac) {
        double s0 = 0.0;
        double s1 = 0.0;
        double s = 0.0;
        double xfracCompl = 1.0 - xfrac;
        double yfracCompl = 1.0 - yfrac;
        if (w00 == 0.0 && w01 == 0.0 && w10 == 0.0 && w11 == 0.0) {
            return this.destinationNoData;
        }
        if (w00 == 0.0 || w01 == 0.0 || w10 == 0.0 || w11 == 0.0) {
            s0 = w00 == 0.0 && w01 == 0.0 ? 0.0 : (w00 == 0.0 ? s01 * xfrac : (w01 == 0.0 ? s00 * xfracCompl : (s01 - s00) * xfrac + s00));
            s1 = w10 == 0.0 && w11 == 0.0 ? 0.0 : (w10 == 0.0 ? s11 * xfrac : (w11 == 0.0 ? s10 * xfracCompl : (s11 - s10) * xfrac + s10));
            s = w00 == 0.0 && w01 == 0.0 ? s1 * yfrac : (w10 == 0.0 && w11 == 0.0 ? s0 * yfracCompl : (s1 - s0) * yfrac + s0);
        } else {
            s0 = (s01 - s00) * xfrac + s00;
            s1 = (s11 - s10) * xfrac + s10;
            s = (s1 - s0) * yfrac + s0;
        }
        if (dataType == 4) {
            return Float.valueOf((float)s);
        }
        return s;
    }
}

