/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import org.apache.commons.lang.math.DoubleRange;
import org.apache.commons.lang.math.FloatRange;
import org.apache.commons.lang.math.IntRange;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeTest {
    private static final int BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean SINGLE_POINT = Boolean.getBoolean("JAI.Ext.SinglePoint");
    private static final Integer TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    private static byte[] arrayB;
    private static short[] arrayUS;
    private static short[] arrayS;
    private static int[] arrayI;
    private static float[] arrayF;
    private static double[] arrayD;
    private static long[] arrayL;
    private static Byte[] arrayBtest;
    private static Short[] arrayStest;
    private static Integer[] arrayItest;
    private static Float[] arrayFtest;
    private static Double[] arrayDtest;
    private static Range rangeB2bounds;
    private static Range rangeBpoint;
    private static Range rangeU2bounds;
    private static Range rangeUpoint;
    private static Range rangeS2bounds;
    private static Range rangeSpoint;
    private static Range rangeI2bounds;
    private static Range rangeIpoint;
    private static Range rangeF2bounds;
    private static Range rangeFpoint;
    private static Range rangeD2bounds;
    private static Range rangeDpoint;
    private static Range rangeL2bounds;
    private static Range rangeLpoint;
    private static org.jaitools.numeric.Range<Byte> rangeJTB;
    private static org.jaitools.numeric.Range<Short> rangeJTS;
    private static org.jaitools.numeric.Range<Integer> rangeJTI;
    private static org.jaitools.numeric.Range<Float> rangeJTF;
    private static org.jaitools.numeric.Range<Double> rangeJTD;
    private static org.jaitools.numeric.Range<Byte> rangeJTBpoint;
    private static org.jaitools.numeric.Range<Short> rangeJTSpoint;
    private static org.jaitools.numeric.Range<Integer> rangeJTIpoint;
    private static org.jaitools.numeric.Range<Float> rangeJTFpoint;
    private static org.jaitools.numeric.Range<Double> rangeJTDpoint;
    private static javax.media.jai.util.Range rangeJAIB;
    private static javax.media.jai.util.Range rangeJAIS;
    private static javax.media.jai.util.Range rangeJAII;
    private static javax.media.jai.util.Range rangeJAIF;
    private static javax.media.jai.util.Range rangeJAID;
    private static javax.media.jai.util.Range rangeJAIBpoint;
    private static javax.media.jai.util.Range rangeJAISpoint;
    private static javax.media.jai.util.Range rangeJAIIpoint;
    private static javax.media.jai.util.Range rangeJAIFpoint;
    private static javax.media.jai.util.Range rangeJAIDpoint;
    private static IntRange rangeCommonsB;
    private static IntRange rangeCommonsS;
    private static IntRange rangeCommonsI;
    private static FloatRange rangeCommonsF;
    private static DoubleRange rangeCommonsD;
    private static IntRange rangeCommonsBpoint;
    private static IntRange rangeCommonsSpoint;
    private static IntRange rangeCommonsIpoint;
    private static FloatRange rangeCommonsFpoint;
    private static DoubleRange rangeCommonsDpoint;

    @BeforeClass
    public static void initialSetup() {
        arrayB = new byte[]{0, 1, 5, 50, 100};
        arrayUS = new short[]{0, 1, 5, 50, 100};
        arrayS = new short[]{-10, 0, 5, 50, 100};
        arrayI = new int[]{-10, 0, 5, 50, 100};
        arrayF = new float[]{-10.0f, 0.0f, 5.0f, 50.0f, 100.0f};
        arrayD = new double[]{-10.0, 0.0, 5.0, 50.0, 100.0};
        arrayL = new long[]{-10L, 0L, 5L, 50L, 100L};
        rangeB2bounds = RangeFactory.create((byte)2, (boolean)true, (byte)60, (boolean)true);
        rangeBpoint = RangeFactory.create((byte)arrayB[2], (boolean)true, (byte)arrayB[2], (boolean)true);
        rangeU2bounds = RangeFactory.createU((short)2, (boolean)true, (short)60, (boolean)true);
        rangeUpoint = RangeFactory.createU((short)arrayUS[2], (boolean)true, (short)arrayUS[2], (boolean)true);
        rangeS2bounds = RangeFactory.create((short)1, (boolean)true, (short)60, (boolean)true);
        rangeSpoint = RangeFactory.create((short)arrayS[2], (boolean)true, (short)arrayS[2], (boolean)true);
        rangeI2bounds = RangeFactory.create((int)1, (boolean)true, (int)60, (boolean)true);
        rangeIpoint = RangeFactory.create((int)arrayI[2], (boolean)true, (int)arrayI[2], (boolean)true);
        rangeF2bounds = RangeFactory.create((float)0.5f, (boolean)true, (float)60.5f, (boolean)true, (boolean)false);
        rangeFpoint = RangeFactory.create((float)arrayF[2], (boolean)true, (float)arrayF[2], (boolean)true, (boolean)false);
        rangeD2bounds = RangeFactory.create((double)1.5, (boolean)true, (double)60.5, (boolean)true, (boolean)false);
        rangeDpoint = RangeFactory.create((double)arrayD[2], (boolean)true, (double)arrayD[2], (boolean)true, (boolean)false);
        rangeL2bounds = RangeFactory.create((long)1L, (boolean)true, (long)60L, (boolean)true);
        rangeLpoint = RangeFactory.create((long)arrayL[2], (boolean)true, (long)arrayL[2], (boolean)true);
        arrayBtest = new Byte[100];
        arrayStest = new Short[100];
        arrayItest = new Integer[100];
        arrayFtest = new Float[100];
        arrayDtest = new Double[100];
        for (int j = 0; j < 100; ++j) {
            double randomValue = Math.random();
            RangeTest.arrayBtest[j] = (byte)(randomValue * 255.0 + -128.0);
            RangeTest.arrayStest[j] = (short)(randomValue * 65535.0 + -32768.0);
            RangeTest.arrayItest[j] = (int)(randomValue * -1.0 + -2.147483648E9);
            RangeTest.arrayFtest[j] = Float.valueOf((float)(randomValue * 3.4028234663852886E38 + (double)1.4E-45f));
            RangeTest.arrayDtest[j] = randomValue * Double.MAX_VALUE + Double.MIN_VALUE;
        }
        rangeJTB = org.jaitools.numeric.Range.create((Number)1, (boolean)true, (Number)60, (boolean)true);
        rangeJTS = org.jaitools.numeric.Range.create((Number)1, (boolean)true, (Number)60, (boolean)true);
        rangeJTI = org.jaitools.numeric.Range.create((Number)1, (boolean)true, (Number)60, (boolean)true);
        rangeJTF = org.jaitools.numeric.Range.create((Number)Float.valueOf(0.5f), (boolean)true, (Number)Float.valueOf(60.5f), (boolean)true);
        rangeJTD = org.jaitools.numeric.Range.create((Number)1.5, (boolean)true, (Number)60.5, (boolean)true);
        rangeJTBpoint = org.jaitools.numeric.Range.create((Number)5, (boolean)true, (Number)5, (boolean)true);
        rangeJTSpoint = org.jaitools.numeric.Range.create((Number)5, (boolean)true, (Number)5, (boolean)true);
        rangeJTIpoint = org.jaitools.numeric.Range.create((Number)5, (boolean)true, (Number)5, (boolean)true);
        rangeJTFpoint = org.jaitools.numeric.Range.create((Number)Float.valueOf(5.0f), (boolean)true, (Number)Float.valueOf(5.0f), (boolean)true);
        rangeJTDpoint = org.jaitools.numeric.Range.create((Number)5.0, (boolean)true, (Number)5.0, (boolean)true);
        rangeJAIB = new javax.media.jai.util.Range(Byte.class, (Comparable)Byte.valueOf((byte)1), true, (Comparable)Byte.valueOf((byte)60), true);
        rangeJAIS = new javax.media.jai.util.Range(Short.class, (Comparable)Short.valueOf((short)1), true, (Comparable)Short.valueOf((short)60), true);
        rangeJAII = new javax.media.jai.util.Range(Integer.class, (Comparable)Integer.valueOf(1), true, (Comparable)Integer.valueOf(60), true);
        rangeJAIF = new javax.media.jai.util.Range(Float.class, (Comparable)Float.valueOf(0.5f), true, (Comparable)Float.valueOf(60.5f), true);
        rangeJAID = new javax.media.jai.util.Range(Double.class, (Comparable)Double.valueOf(1.5), true, (Comparable)Double.valueOf(60.5), true);
        rangeJAIBpoint = new javax.media.jai.util.Range(Byte.class, (Comparable)Byte.valueOf((byte)5), true, (Comparable)Byte.valueOf((byte)5), true);
        rangeJAISpoint = new javax.media.jai.util.Range(Short.class, (Comparable)Short.valueOf((short)5), true, (Comparable)Short.valueOf((short)5), true);
        rangeJAIIpoint = new javax.media.jai.util.Range(Integer.class, (Comparable)Integer.valueOf(5), true, (Comparable)Integer.valueOf(5), true);
        rangeJAIFpoint = new javax.media.jai.util.Range(Float.class, (Comparable)Float.valueOf(5.0f), true, (Comparable)Float.valueOf(5.0f), true);
        rangeJAIDpoint = new javax.media.jai.util.Range(Double.class, (Comparable)Double.valueOf(5.0), true, (Comparable)Double.valueOf(5.0), true);
        rangeCommonsB = new IntRange(1, 60);
        rangeCommonsS = new IntRange(1, 60);
        rangeCommonsI = new IntRange(1, 60);
        rangeCommonsF = new FloatRange(0.5f, 60.5f);
        rangeCommonsD = new DoubleRange(1.5, 60.5);
        rangeCommonsBpoint = new IntRange(5);
        rangeCommonsSpoint = new IntRange(5);
        rangeCommonsIpoint = new IntRange(5);
        rangeCommonsFpoint = new FloatRange(5.0f);
        rangeCommonsDpoint = new DoubleRange(5.0);
    }

    @Test
    public void testRange() {
        for (int i = 0; i < arrayB.length; ++i) {
            boolean check2pointByte = rangeB2bounds.contains(arrayB[i]);
            boolean check1pointByte = rangeBpoint.contains(arrayB[i]);
            boolean check2pointUshort = rangeU2bounds.contains(arrayUS[i]);
            boolean check1pointUshort = rangeUpoint.contains(arrayUS[i]);
            boolean check2pointShort = rangeS2bounds.contains(arrayS[i]);
            boolean check1pointShort = rangeSpoint.contains(arrayS[i]);
            boolean check2pointInt = rangeI2bounds.contains(arrayI[i]);
            boolean check1pointInt = rangeIpoint.contains(arrayI[i]);
            boolean check2pointFloat = rangeF2bounds.contains(arrayF[i]);
            boolean check1pointFloat = rangeFpoint.contains(arrayF[i]);
            boolean check2pointDouble = rangeD2bounds.contains(arrayD[i]);
            boolean check1pointDouble = rangeDpoint.contains(arrayD[i]);
            boolean check2pointLong = rangeL2bounds.contains(arrayL[i]);
            boolean check1pointLong = rangeLpoint.contains(arrayL[i]);
            if (i == 2) {
                Assert.assertTrue((boolean)check1pointByte);
                Assert.assertTrue((boolean)check2pointByte);
                Assert.assertTrue((boolean)check1pointUshort);
                Assert.assertTrue((boolean)check2pointUshort);
                Assert.assertTrue((boolean)check1pointShort);
                Assert.assertTrue((boolean)check2pointShort);
                Assert.assertTrue((boolean)check1pointInt);
                Assert.assertTrue((boolean)check2pointInt);
                Assert.assertTrue((boolean)check1pointFloat);
                Assert.assertTrue((boolean)check2pointFloat);
                Assert.assertTrue((boolean)check1pointDouble);
                Assert.assertTrue((boolean)check2pointDouble);
                Assert.assertTrue((boolean)check1pointLong);
                Assert.assertTrue((boolean)check2pointLong);
                continue;
            }
            if (i == 3) {
                Assert.assertFalse((boolean)check1pointByte);
                Assert.assertTrue((boolean)check2pointByte);
                Assert.assertFalse((boolean)check1pointUshort);
                Assert.assertTrue((boolean)check2pointUshort);
                Assert.assertFalse((boolean)check1pointShort);
                Assert.assertTrue((boolean)check2pointShort);
                Assert.assertFalse((boolean)check1pointInt);
                Assert.assertTrue((boolean)check2pointInt);
                Assert.assertFalse((boolean)check1pointFloat);
                Assert.assertTrue((boolean)check2pointFloat);
                Assert.assertFalse((boolean)check1pointDouble);
                Assert.assertTrue((boolean)check2pointDouble);
                Assert.assertFalse((boolean)check1pointLong);
                Assert.assertTrue((boolean)check2pointLong);
                continue;
            }
            Assert.assertFalse((boolean)check1pointByte);
            Assert.assertFalse((boolean)check2pointByte);
            Assert.assertFalse((boolean)check1pointUshort);
            Assert.assertFalse((boolean)check2pointUshort);
            Assert.assertFalse((boolean)check1pointShort);
            Assert.assertFalse((boolean)check2pointShort);
            Assert.assertFalse((boolean)check1pointInt);
            Assert.assertFalse((boolean)check2pointInt);
            Assert.assertFalse((boolean)check1pointFloat);
            Assert.assertFalse((boolean)check2pointFloat);
            Assert.assertFalse((boolean)check1pointDouble);
            Assert.assertFalse((boolean)check2pointDouble);
            Assert.assertFalse((boolean)check1pointLong);
            Assert.assertFalse((boolean)check2pointLong);
        }
    }

    @Test
    public void testRangeTimeByte1or2Points() {
        block15: {
            block14: {
                if (SINGLE_POINT) break block14;
                switch (TEST_SELECTOR) {
                    case 0: {
                        this.testRangeTimeByte(rangeB2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 2: {
                        this.testRangeTimeShort(rangeS2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 3: {
                        this.testRangeTimeInteger(rangeI2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 4: {
                        this.testRangeTimeFloat(rangeF2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 5: {
                        this.testRangeTimeDouble(rangeD2bounds, SINGLE_POINT);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            switch (TEST_SELECTOR) {
                case 0: {
                    this.testRangeTimeByte(rangeBpoint, SINGLE_POINT);
                    break;
                }
                case 2: {
                    this.testRangeTimeShort(rangeSpoint, SINGLE_POINT);
                    break;
                }
                case 3: {
                    this.testRangeTimeInteger(rangeIpoint, SINGLE_POINT);
                    break;
                }
                case 4: {
                    this.testRangeTimeFloat(rangeFpoint, SINGLE_POINT);
                    break;
                }
                case 5: {
                    this.testRangeTimeDouble(rangeDpoint, SINGLE_POINT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
    }

    @Test
    public void testJaiToolsRangeTimeByte1or2Points() {
        block15: {
            block14: {
                if (SINGLE_POINT) break block14;
                switch (TEST_SELECTOR) {
                    case 0: {
                        this.testJaiToolsRangeTime(rangeJTB, SINGLE_POINT, arrayBtest);
                        break block15;
                    }
                    case 2: {
                        this.testJaiToolsRangeTime(rangeJTS, SINGLE_POINT, arrayStest);
                        break block15;
                    }
                    case 3: {
                        this.testJaiToolsRangeTime(rangeJTI, SINGLE_POINT, arrayItest);
                        break block15;
                    }
                    case 4: {
                        this.testJaiToolsRangeTime(rangeJTF, SINGLE_POINT, arrayFtest);
                        break block15;
                    }
                    case 5: {
                        this.testJaiToolsRangeTime(rangeJTD, SINGLE_POINT, arrayDtest);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            switch (TEST_SELECTOR) {
                case 0: {
                    this.testJaiToolsRangeTime(rangeJTBpoint, SINGLE_POINT, arrayBtest);
                    break;
                }
                case 2: {
                    this.testJaiToolsRangeTime(rangeJTSpoint, SINGLE_POINT, arrayStest);
                    break;
                }
                case 3: {
                    this.testJaiToolsRangeTime(rangeJTIpoint, SINGLE_POINT, arrayItest);
                    break;
                }
                case 4: {
                    this.testJaiToolsRangeTime(rangeJTFpoint, SINGLE_POINT, arrayFtest);
                    break;
                }
                case 5: {
                    this.testJaiToolsRangeTime(rangeJTDpoint, SINGLE_POINT, arrayDtest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
    }

    @Test
    public void testJAIRangeTimeByte1or2Points() {
        block15: {
            block14: {
                if (SINGLE_POINT) break block14;
                switch (TEST_SELECTOR) {
                    case 0: {
                        this.testJAIRangeTime(rangeJAIB, SINGLE_POINT, arrayBtest);
                        break block15;
                    }
                    case 2: {
                        this.testJAIRangeTime(rangeJAIS, SINGLE_POINT, arrayStest);
                        break block15;
                    }
                    case 3: {
                        this.testJAIRangeTime(rangeJAII, SINGLE_POINT, arrayItest);
                        break block15;
                    }
                    case 4: {
                        this.testJAIRangeTime(rangeJAIF, SINGLE_POINT, arrayFtest);
                        break block15;
                    }
                    case 5: {
                        this.testJAIRangeTime(rangeJAID, SINGLE_POINT, arrayDtest);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            switch (TEST_SELECTOR) {
                case 0: {
                    this.testJAIRangeTime(rangeJAIBpoint, SINGLE_POINT, arrayBtest);
                    break;
                }
                case 2: {
                    this.testJAIRangeTime(rangeJAISpoint, SINGLE_POINT, arrayStest);
                    break;
                }
                case 3: {
                    this.testJAIRangeTime(rangeJAIIpoint, SINGLE_POINT, arrayItest);
                    break;
                }
                case 4: {
                    this.testJAIRangeTime(rangeJAIFpoint, SINGLE_POINT, arrayFtest);
                    break;
                }
                case 5: {
                    this.testJAIRangeTime(rangeJAIDpoint, SINGLE_POINT, arrayDtest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
    }

    @Test
    public void testApacheCommonRangeTimeByte1or2Points() {
        block15: {
            block14: {
                if (SINGLE_POINT) break block14;
                switch (TEST_SELECTOR) {
                    case 0: {
                        this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsB, SINGLE_POINT, arrayBtest);
                        break block15;
                    }
                    case 2: {
                        this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsS, SINGLE_POINT, arrayStest);
                        break block15;
                    }
                    case 3: {
                        this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsI, SINGLE_POINT, arrayItest);
                        break block15;
                    }
                    case 4: {
                        this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsF, SINGLE_POINT, arrayFtest);
                        break block15;
                    }
                    case 5: {
                        this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsD, SINGLE_POINT, arrayDtest);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            switch (TEST_SELECTOR) {
                case 0: {
                    this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsBpoint, SINGLE_POINT, arrayBtest);
                    break;
                }
                case 2: {
                    this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsSpoint, SINGLE_POINT, arrayStest);
                    break;
                }
                case 3: {
                    this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsIpoint, SINGLE_POINT, arrayItest);
                    break;
                }
                case 4: {
                    this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsFpoint, SINGLE_POINT, arrayFtest);
                    break;
                }
                case 5: {
                    this.testApacheCommonsRangeTime((org.apache.commons.lang.math.Range)rangeCommonsDpoint, SINGLE_POINT, arrayDtest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
    }

    public void testRangeTimeByte(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayBtest.length; ++j) {
                testRange.contains(arrayBtest[j].byteValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Byte data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeShort(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayStest.length; ++j) {
                testRange.contains(arrayStest[j].shortValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Short data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeInteger(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayItest.length; ++j) {
                testRange.contains(arrayItest[j].intValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Integer data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeFloat(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayFtest.length; ++j) {
                testRange.contains(arrayFtest[j].floatValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Float data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeDouble(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayDtest.length; ++j) {
                testRange.contains(arrayDtest[j].doubleValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Double data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public <T extends Number> void testJaiToolsRangeTime(org.jaitools.numeric.Range<T> testRange, boolean isPoint, T[] array) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < array.length; ++j) {
                testRange.contains(array[j]);
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("\nMean value for" + description + " JAITools Range : " + meanValue + " nsec.");
    }

    public <T extends Number> void testJAIRangeTime(javax.media.jai.util.Range testRange, boolean isPoint, T[] array) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < array.length; ++j) {
                testRange.contains((Comparable)array[j]);
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("\nMean value for" + description + " JAI Range : " + meanValue + " nsec.");
    }

    public <T extends Number> void testApacheCommonsRangeTime(org.apache.commons.lang.math.Range testRange, boolean isPoint, T[] array) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < array.length; ++j) {
                testRange.containsNumber(array[j]);
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("\nMean value for" + description + " Apache Common Range : " + meanValue + " nsec.");
    }
}

