/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.testclasses;

import it.geosolutions.jaiext.JAIExt;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ROIShape;
import javax.media.jai.TiledImage;
import org.junit.BeforeClass;

public abstract class TestBase {
    public static int DEFAULT_WIDTH = 256;
    public static int DEFAULT_HEIGHT = 256;
    public static final int DEFAULT_SUBSAMPLE_BITS = 8;
    public static final int DEFAULT_PRECISION_BITS = 8;
    public static boolean INTERACTIVE = Boolean.getBoolean("JAI.Ext.Interactive");
    public static boolean IMAGE_FILLER = Boolean.getBoolean("JAI.Ext.ImageFill");
    public static Integer INVERSE_SCALE = Integer.getInteger("JAI.Ext.InverseScale", 0);
    public static Integer TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    protected double destinationNoData;
    protected float transX = 0.0f;
    protected float transY = 0.0f;
    protected float scaleX = 0.5f;
    protected float scaleY = 0.5f;

    protected ROIShape roiCreation() {
        int roiHeight = DEFAULT_HEIGHT * 3 / 4;
        int roiWidth = DEFAULT_WIDTH * 3 / 4;
        Rectangle roiBound = new Rectangle(0, 0, roiWidth, roiHeight);
        ROIShape roi = new ROIShape((Shape)roiBound);
        return roi;
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary) {
        return TestBase.createTestImage(dataType, width, height, noDataValue, isBinary, 3);
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary, int bands) {
        return TestBase.createTestImage(dataType, width, height, noDataValue, isBinary, bands, null);
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary, int bands, Number validData) {
        SampleModel sm;
        int valueB = validData != null ? (int)validData.byteValue() : 64;
        int valueUS = validData != null ? (int)validData.shortValue() : 8191;
        int valueS = validData != null ? (int)validData.shortValue() : -50;
        int valueI = validData != null ? validData.intValue() : 100;
        float valueF = validData != null ? validData.floatValue() : 635.0f;
        double valueD = validData != null ? validData.doubleValue() : 1020.0;
        boolean fillImage = IMAGE_FILLER;
        int tileW = width / 8;
        int tileH = height / 8;
        int imageDim = width * height;
        Byte crossValueByte = null;
        Short crossValueUShort = null;
        Short crossValueShort = null;
        Integer crossValueInteger = null;
        Float crossValueFloat = null;
        Double crossValueDouble = null;
        int numBands = bands;
        if (isBinary) {
            sm = new MultiPixelPackedSampleModel(dataType, width, height, 1);
            numBands = 1;
        } else {
            sm = numBands == 3 ? new ComponentSampleModel(dataType, width, height, 3, width, new int[]{0, imageDim, imageDim * 2}) : new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        }
        switch (dataType) {
            case 0: {
                crossValueByte = (Byte)noDataValue;
                break;
            }
            case 1: {
                crossValueUShort = (Short)noDataValue;
                break;
            }
            case 2: {
                crossValueShort = (Short)noDataValue;
                break;
            }
            case 3: {
                crossValueInteger = (Integer)noDataValue;
                break;
            }
            case 4: {
                crossValueFloat = (Float)noDataValue;
                break;
            }
            case 5: {
                crossValueDouble = (Double)noDataValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        TiledImage used = new TiledImage(sm, tileW, tileH);
        int imgBinX = width / 4;
        int imgBinY = height / 4;
        int imgBinWidth = imgBinX + width / 4;
        int imgBinHeight = imgBinY + height / 4;
        for (int b = 0; b < numBands; ++b) {
            for (int j = 0; j < width; ++j) {
                block64: for (int k = 0; k < height; ++k) {
                    if (j == k || j == width - k - 1) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                continue block64;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                continue block64;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                continue block64;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                continue block64;
                            }
                            case 4: {
                                used.setSample(j, k, b, crossValueFloat.floatValue());
                                continue block64;
                            }
                            case 5: {
                                used.setSample(j, k, b, crossValueDouble.doubleValue());
                                continue block64;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (!isBinary && fillImage) {
                        if (j >= 20 && j < 50 && k >= 20 && k < 50) {
                            switch (dataType) {
                                case 0: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 1: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 2: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 3: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 4: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 5: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Wrong data type");
                                }
                            }
                            if (j < 30 || j >= 40 || k < 20 || k >= 30) continue;
                            switch (dataType) {
                                case 0: {
                                    used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                    continue block64;
                                }
                                case 1: {
                                    used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                    continue block64;
                                }
                                case 2: {
                                    used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                    continue block64;
                                }
                                case 3: {
                                    used.setSample(j, k, b, crossValueInteger.intValue());
                                    continue block64;
                                }
                                case 4: {
                                    used.setSample(j, k, b, crossValueFloat.floatValue());
                                    continue block64;
                                }
                                case 5: {
                                    used.setSample(j, k, b, crossValueDouble.doubleValue());
                                    continue block64;
                                }
                                default: {
                                    throw new IllegalArgumentException("Wrong data type");
                                }
                            }
                        }
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, valueB + b);
                                break;
                            }
                            case 1: {
                                used.setSample(j, k, b, valueUS + b);
                                break;
                            }
                            case 2: {
                                used.setSample(j, k, b, valueS + b);
                                break;
                            }
                            case 3: {
                                used.setSample(j, k, b, valueI + b);
                                break;
                            }
                            case 4: {
                                float data = valueF + (float)b / 3.0f;
                                used.setSample(j, k, b, data);
                                break;
                            }
                            case 5: {
                                double dataD = valueD + (double)b / 3.0;
                                used.setSample(j, k, b, dataD);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                        continue;
                    }
                    if (isBinary && j > imgBinX && j < imgBinWidth && j > imgBinY && j < imgBinHeight) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                continue block64;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                continue block64;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                continue block64;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                continue block64;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (j >= 2 && j < 10 && k >= 2 && k < 10) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                break;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                break;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                break;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                break;
                            }
                            case 4: {
                                used.setSample(j, k, b, crossValueFloat.floatValue());
                                break;
                            }
                            case 5: {
                                used.setSample(j, k, b, crossValueDouble.doubleValue());
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (j < 150 || j >= 170 || k < 90 || k >= 110) continue;
                    switch (dataType) {
                        case 0: {
                            used.setSample(j, k, b, (int)crossValueByte.byteValue());
                            continue block64;
                        }
                        case 1: {
                            used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                            continue block64;
                        }
                        case 2: {
                            used.setSample(j, k, b, (int)crossValueShort.shortValue());
                            continue block64;
                        }
                        case 3: {
                            used.setSample(j, k, b, crossValueInteger.intValue());
                            continue block64;
                        }
                        case 4: {
                            used.setSample(j, k, b, crossValueFloat.floatValue());
                            continue block64;
                        }
                        case 5: {
                            used.setSample(j, k, b, crossValueDouble.doubleValue());
                            continue block64;
                        }
                        default: {
                            throw new IllegalArgumentException("Wrong data type");
                        }
                    }
                }
            }
        }
        return used;
    }

    @BeforeClass
    public static void setup() {
        JAIExt.initJAIEXT();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransformationType {
        ROTATE_OP(0),
        TRANSLATE_OP(2),
        SCALE_OP(1),
        ALL(3);

        private int value;

        private TransformationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestSelection {
        NO_ROI_ONLY_DATA(0),
        ROI_ACCESSOR_ONLY_DATA(1),
        ROI_ONLY_DATA(2),
        ROI_ACCESSOR_NO_DATA(3),
        NO_ROI_NO_DATA(4),
        ROI_NO_DATA(5),
        BINARY_ROI_ACCESSOR_NO_DATA(6);

        private int type;

        private TestSelection(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleType {
        MAGNIFY(0),
        REDUCTION(1);

        private int type;

        private ScaleType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InterpolationType {
        NEAREST_INTERP(0),
        BILINEAR_INTERP(1),
        BICUBIC_INTERP(2),
        GENERAL_INTERP(3);

        private int type;

        private InterpolationType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

