/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.testclasses;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

public class TestData {
    private static final String DIRECTORY = "test-data";
    private static final String ENCODING = "UTF-8";

    public static File file(Object caller, String path) throws FileNotFoundException, IOException {
        URL url = TestData.getResource(caller, path);
        if (url == null) {
            throw new FileNotFoundException("Can not locate test-data for \"" + path + '\"');
        }
        File file = new File(URLDecoder.decode(url.getPath(), ENCODING));
        if (!file.exists()) {
            throw new FileNotFoundException("Can not locate test-data for \"" + path + '\"');
        }
        return file;
    }

    public static URL getResource(Object caller, String name) {
        name = name == null || (name = name.trim()).length() == 0 ? DIRECTORY : "test-data/" + name;
        if (caller != null) {
            Class<?> c = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            return c.getResource(name);
        }
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }
}

