/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeDouble
extends Range {
    private final double minValue;
    private final double maxValue;
    private final long intValue;
    private final boolean isPoint;
    private final boolean isNaN;
    private final boolean nanIncluded;

    RangeDouble(double minValue, boolean minIncluded, double maxValue, boolean maxIncluded, boolean nanIncluded) {
        super(minIncluded, maxIncluded);
        if (Double.isNaN(minValue) && !Double.isNaN(maxValue) || !Double.isNaN(minValue) && Double.isNaN(maxValue)) {
            throw new UnsupportedOperationException("NaN values can only be set inside a single-point Range");
        }
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
            this.isNaN = false;
            this.intValue = 0L;
            this.nanIncluded = nanIncluded;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
            this.isNaN = false;
            this.intValue = 0L;
            this.nanIncluded = nanIncluded;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            this.nanIncluded = false;
            if (Double.isNaN(minValue)) {
                this.isNaN = true;
                this.intValue = Double.doubleToLongBits(minValue);
            } else {
                this.isNaN = false;
                this.intValue = 0L;
            }
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    public boolean contains(double value) {
        boolean notLower;
        if (this.isPoint) {
            if (this.isNaN) {
                long valueLong = Double.doubleToLongBits(value);
                return valueLong == this.intValue;
            }
            return this.minValue == value;
        }
        if (this.nanIncluded) {
            boolean lower;
            if (this.isMinIncluded()) {
                lower = value < this.minValue;
            } else {
                boolean bl = lower = value <= this.minValue;
            }
            boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
            return !lower && !upper;
        }
        if (this.isMinIncluded()) {
            notLower = value >= this.minValue;
        } else {
            boolean bl = notLower = value > this.minValue;
        }
        boolean notUpper = this.isMaxIncluded() ? value <= this.maxValue : value < this.maxValue;
        return notLower && notUpper;
    }

    public Range.DataType getDataType() {
        return Range.DataType.DOUBLE;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public Number getMax() {
        return this.maxValue;
    }

    public Number getMin() {
        return this.minValue;
    }

    public Number getMax(boolean isMaxIncluded) {
        double value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    public Number getMin(boolean isMinIncluded) {
        double value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    public boolean isNanIncluded() {
        return this.nanIncluded;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        double min2 = other.getMin().doubleValue();
        double max2 = other.getMax().doubleValue();
        double finalMin = this.minValue;
        double finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        boolean isNaNIncluded = this.isNaN() || other.isNaN() || this.isNanIncluded() || other.isNanIncluded();
        return new RangeDouble(finalMin, minIncluded, finalMax, maxIncluded, isNaNIncluded);
    }
}

