/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeInt
extends Range {
    private final int minValue;
    private final int maxValue;
    private final boolean isPoint;

    RangeInt(int minValue, boolean minIncluded, int maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    public boolean contains(int value) {
        boolean lower;
        if (this.isPoint) {
            return this.minValue == value;
        }
        if (this.isMinIncluded()) {
            lower = value < this.minValue;
        } else {
            boolean bl = lower = value <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
        return !lower && !upper;
    }

    public Range.DataType getDataType() {
        return Range.DataType.INTEGER;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public Number getMax() {
        return this.maxValue;
    }

    public Number getMin() {
        return this.minValue;
    }

    public Number getMax(boolean isMaxIncluded) {
        int value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (int)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    public Number getMin(boolean isMinIncluded) {
        int value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (int)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        int min2 = other.getMin().intValue();
        int max2 = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeInt(finalMin, minIncluded, finalMax, maxIncluded);
    }
}

