/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeShort
extends Range {
    private final short minValue;
    private final short maxValue;
    private final boolean isPoint;

    RangeShort(short minValue, boolean minIncluded, short maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    public boolean contains(short value) {
        boolean lower;
        if (this.isPoint) {
            return this.minValue == value;
        }
        if (this.isMinIncluded()) {
            lower = value < this.minValue;
        } else {
            boolean bl = lower = value <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
        return !lower && !upper;
    }

    public Range.DataType getDataType() {
        return Range.DataType.SHORT;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public Number getMax() {
        return this.maxValue;
    }

    public Number getMin() {
        return this.minValue;
    }

    public Number getMax(boolean isMaxIncluded) {
        short value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    public Number getMin(boolean isMinIncluded) {
        short value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        short min2 = other.getMin().shortValue();
        short max2 = other.getMax().shortValue();
        short finalMin = this.minValue;
        short finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeShort(finalMin, minIncluded, finalMax, maxIncluded);
    }
}

