/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext;

import it.geosolutions.jaiext.ConcurrentOperationRegistry;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.testclasses.TestData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAIEXTInitializationTest {
    private static final String SCALE = "Scale";
    private static final String CRIF = "it.geosolutions.jaiext.DummyScaleCRIF";
    private static File newJAIFile;

    @BeforeClass
    public static void setup() throws FileNotFoundException, IOException {
        File inputJAIFile = TestData.file(JAIEXTInitializationTest.class, "META-INF" + File.separator + "registryFile2.jaiext");
        newJAIFile = new File(inputJAIFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "META-INF" + File.separator + "registryFile.jaiext");
        FileUtils.copyFile((File)inputJAIFile, (File)newJAIFile);
    }

    @Test
    public void testJAIEXTReInit() {
        JAIExt.initJAIEXT((boolean)false, (boolean)true);
        ConcurrentOperationRegistry registry = JAIExt.getRegistry();
        ConcurrentOperationRegistry.OperationCollection operations = registry.getOperationCollection();
        ConcurrentOperationRegistry.OperationItem operationItem = operations.get(SCALE);
        Assert.assertTrue((operationItem != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)operationItem.getVendor().equalsIgnoreCase("com.sun.media.jai"));
        Assert.assertTrue((!operationItem.getCurrentFactory().getClass().getName().equalsIgnoreCase(CRIF) ? 1 : 0) != 0);
        JAIExt.initJAIEXT((boolean)true, (boolean)true);
        registry = JAIExt.getRegistry();
        operations = registry.getOperationCollection();
        operationItem = operations.get(SCALE);
        Assert.assertTrue((operationItem != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)operationItem.getVendor().equalsIgnoreCase("it.geosolutions.jaiext"));
        Assert.assertTrue((boolean)operationItem.getCurrentFactory().getClass().getName().equalsIgnoreCase(CRIF));
    }

    @AfterClass
    public static void fileDisposal() {
        FileUtils.deleteQuietly((File)newJAIFile);
        FileUtils.deleteQuietly((File)newJAIFile.getParentFile());
    }
}

