/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext;

import it.geosolutions.jaiext.BufferedImageAdapter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class BufferedImageAdapterTest {
    @Test
    public void testBufferedImage() {
        BufferedImage bi = new BufferedImage(768, 768, 6);
        BufferedImageAdapter adapter = new BufferedImageAdapter(bi);
        Assert.assertEquals((long)0L, (long)adapter.getMinX());
        Assert.assertEquals((long)0L, (long)adapter.getMinY());
        Assert.assertEquals((long)0L, (long)adapter.getMinTileX());
        Assert.assertEquals((long)0L, (long)adapter.getMinTileY());
        Assert.assertEquals((long)0L, (long)adapter.getTileGridXOffset());
        Assert.assertEquals((long)0L, (long)adapter.getTileGridYOffset());
        RenderedOp op = BandSelectDescriptor.create((RenderedImage)adapter, (int[])new int[1], null);
        Assert.assertSame((Object)adapter, (Object)op.getSourceObject(0));
        Assert.assertNotNull((Object)op.getTile(op.getMinTileX(), op.getMinTileY()));
    }

    @Test
    public void testSubimage() {
        BufferedImage bi = new BufferedImage(768, 768, 6);
        BufferedImage subimage = bi.getSubimage(0, 512, 256, 256);
        BufferedImageAdapter adapter = new BufferedImageAdapter(subimage);
        Assert.assertEquals((long)0L, (long)adapter.getMinX());
        Assert.assertEquals((long)0L, (long)adapter.getMinY());
        Assert.assertEquals((long)0L, (long)adapter.getMinTileX());
        Assert.assertEquals((long)0L, (long)adapter.getMinTileY());
        Assert.assertEquals((long)0L, (long)adapter.getTileGridXOffset());
        Assert.assertEquals((long)0L, (long)adapter.getTileGridYOffset());
        RenderedOp op = BandSelectDescriptor.create((RenderedImage)adapter, (int[])new int[1], null);
        Assert.assertSame((Object)adapter, (Object)op.getSourceObject(0));
        Assert.assertNotNull((Object)op.getTile(op.getMinTileX(), op.getMinTileY()));
    }

    @Test
    public void testGetData() {
        BufferedImage bi = new BufferedImage(768, 768, 6);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(512, 512, 256, 256);
        graphics.dispose();
        BufferedImage solidSubimage = bi.getSubimage(512, 512, 256, 256);
        this.assertSolidTile(solidSubimage, 255);
        BufferedImage transparentSubimage = bi.getSubimage(256, 256, 256, 256);
        this.assertSolidTile(transparentSubimage, 0);
    }

    private void assertSolidTile(BufferedImage subimage, int expectedValue) {
        BufferedImageAdapter adapter = new BufferedImageAdapter(subimage);
        Raster raster = adapter.getTile(0, 0);
        this.checkSolidTile(raster, expectedValue);
        raster = adapter.getData();
        this.checkSolidTile(raster, expectedValue);
    }

    private void checkSolidTile(Raster raster, int expectdValue) {
        int[] pixel = new int[4];
        Assert.assertEquals((long)256L, (long)raster.getWidth());
        Assert.assertEquals((long)256L, (long)raster.getHeight());
        for (int i = raster.getMinX(); i < raster.getHeight(); ++i) {
            int j = raster.getMinY();
            while (i < raster.getWidth()) {
                raster.getPixel(j, i, pixel);
                Assert.assertEquals((long)expectdValue, (long)pixel[0]);
                Assert.assertEquals((long)expectdValue, (long)pixel[1]);
                Assert.assertEquals((long)expectdValue, (long)pixel[2]);
                Assert.assertEquals((long)expectdValue, (long)pixel[3]);
                ++i;
            }
        }
    }
}

