/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext;

import com.sun.media.jai.mlib.MlibScaleRIF;
import com.sun.media.jai.opimage.ScaleCRIF;
import it.geosolutions.jaiext.ConcurrentOperationRegistry;
import it.geosolutions.jaiext.DummyScaleCRIF;
import it.geosolutions.jaiext.DummyScaleDescriptor;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.testclasses.TestData;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.operator.ScaleDescriptor;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAIEXTTest {
    private static final String SCALE = "Scale";
    private static File newJAIFile;

    @BeforeClass
    public static void setup() throws FileNotFoundException, IOException {
        File inputJAIFile = TestData.file(JAIEXTTest.class, "META-INF" + File.separator + "registryFile2.jaiext");
        newJAIFile = new File(inputJAIFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "META-INF" + File.separator + "registryFile.jaiext");
        FileUtils.copyFile((File)inputJAIFile, (File)newJAIFile);
        JAIExt.initJAIEXT();
    }

    @Test
    public void testJAIEXT() {
        ConcurrentOperationRegistry registry = JAIExt.getRegistry();
        ConcurrentOperationRegistry.OperationCollection operations = registry.getOperationCollection();
        ConcurrentOperationRegistry.OperationItem operationItem = operations.get(SCALE);
        Assert.assertTrue((operationItem != null ? 1 : 0) != 0);
        JAIExt.registerJAIEXTDescriptor((String)SCALE);
        operations = registry.getOperationCollection();
        operationItem = operations.get(SCALE);
        Assert.assertTrue((boolean)operationItem.getDescriptor().getClass().isAssignableFrom(DummyScaleDescriptor.class));
        Assert.assertTrue((boolean)operationItem.getCurrentFactory().getClass().isAssignableFrom(DummyScaleCRIF.class));
        JAIExt.registerJAIDescriptor((String)SCALE);
        operations = registry.getOperationCollection();
        operationItem = operations.get(SCALE);
        Assert.assertTrue((boolean)operationItem.getDescriptor().getClass().isAssignableFrom(ScaleDescriptor.class));
        Assert.assertTrue((boolean)operationItem.getCurrentFactory().getClass().isAssignableFrom(ScaleCRIF.class));
        JAIExt.registerJAIDescriptor((String)SCALE);
        if (JAIExt.isMedialibavailable()) {
            JAIExt.setJAIAcceleration((String)SCALE, (boolean)true);
            operations = registry.getOperationCollection();
            operationItem = operations.get(SCALE);
            Assert.assertTrue((boolean)operationItem.getCurrentFactory().getClass().isAssignableFrom(MlibScaleRIF.class));
            JAIExt.setJAIAcceleration((String)SCALE, (boolean)false);
            operations = registry.getOperationCollection();
            operationItem = operations.get(SCALE);
            Assert.assertTrue((boolean)operationItem.getCurrentFactory().getClass().isAssignableFrom(ScaleCRIF.class));
        }
    }

    @Test
    public void testInterpolation() {
        ConcurrentOperationRegistry registry = JAIExt.getRegistry();
        JAIExt.registerJAIDescriptor((String)SCALE);
        Object[] args = new Object[1];
        ParameterBlock block = new ParameterBlock();
        block.set(new InterpolationNearest(null, false, 0.0, 0), 0);
        args[0] = block;
        registry.checkInterpolation(SCALE, args);
        Object interp = block.getObjectParameter(0);
        Assert.assertTrue((boolean)interp.getClass().isAssignableFrom(javax.media.jai.InterpolationNearest.class));
        args = new Object[1];
        block = new ParameterBlock();
        int subsampleBits = 8;
        block.set(new InterpolationBilinear(subsampleBits, null, false, 0.0, 0), 0);
        args[0] = block;
        registry.checkInterpolation(SCALE, args);
        interp = block.getObjectParameter(0);
        Assert.assertTrue((boolean)interp.getClass().isAssignableFrom(javax.media.jai.InterpolationBilinear.class));
        Assert.assertTrue((((javax.media.jai.InterpolationBilinear)interp).getSubsampleBitsH() == subsampleBits ? 1 : 0) != 0);
        args = new Object[1];
        block = new ParameterBlock();
        block.set(new InterpolationBicubic(subsampleBits, null, false, 0.0, 0, true, subsampleBits), 0);
        args[0] = block;
        registry.checkInterpolation(SCALE, args);
        interp = block.getObjectParameter(0);
        Assert.assertTrue((boolean)interp.getClass().isAssignableFrom(javax.media.jai.InterpolationBicubic.class));
        Assert.assertTrue((((javax.media.jai.InterpolationBicubic)interp).getSubsampleBitsH() == subsampleBits ? 1 : 0) != 0);
        Assert.assertTrue((((javax.media.jai.InterpolationBicubic)interp).getPrecisionBits() == subsampleBits ? 1 : 0) != 0);
        args = new Object[1];
        block = new ParameterBlock();
        block.set(new InterpolationBicubic(subsampleBits, null, false, 0.0, 0, false, subsampleBits), 0);
        args[0] = block;
        registry.checkInterpolation(SCALE, args);
        interp = block.getObjectParameter(0);
        Assert.assertTrue((boolean)interp.getClass().isAssignableFrom(InterpolationBicubic2.class));
        Assert.assertTrue((((InterpolationBicubic2)interp).getSubsampleBitsH() == subsampleBits ? 1 : 0) != 0);
        Assert.assertTrue((((InterpolationBicubic2)interp).getPrecisionBits() == subsampleBits ? 1 : 0) != 0);
    }

    @AfterClass
    public static void fileDisposal() {
        FileUtils.deleteQuietly((File)newJAIFile);
        FileUtils.deleteQuietly((File)newJAIFile.getParentFile());
    }
}

