/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.warp.WarpBicubicOpImage;
import it.geosolutions.jaiext.warp.WarpBilinearOpImage;
import it.geosolutions.jaiext.warp.WarpDescriptor;
import it.geosolutions.jaiext.warp.WarpNearestOpImage;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestWarp
extends TestBase {
    protected static final double ANGLE_ROTATION = 45.0;
    protected static Warp warpObj;
    protected static final int NUM_IMAGES = 6;
    protected static RenderedImage[] images;
    protected static byte noDataValueB;
    protected static TestBase.InterpolationType interpType;
    protected static short noDataValueU;
    protected static short noDataValueS;
    protected static int noDataValueI;
    protected static float noDataValueF;
    protected static double noDataValueD;

    public void testWarp(RenderedImage source, boolean noDataUsed, boolean roiUsed, Warp warpObj, Number noDataValue, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect) {
        Range noData;
        InterpolationNearest interp;
        int dataType = source.getSampleModel().getDataType();
        ROIShape roi = null;
        if (roiUsed) {
            roi = this.roiCreation();
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        RenderedOp destinationIMG = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interp = new InterpolationNearest();
                break;
            }
            case BILINEAR_INTERP: {
                interp = new InterpolationBilinear(8);
                break;
            }
            case BICUBIC_INTERP: {
                interp = new InterpolationBicubic(8);
                break;
            }
            case GENERAL_INTERP: {
                interp = new InterpolationBicubic(8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong interpolation type");
            }
        }
        double[] background = new double[]{this.destinationNoData};
        destinationIMG = WarpDescriptor.create((RenderedImage)source, (Warp)warpObj, (Interpolation)interp, (double[])background, (ROI)roi, (RenderingHints)hints);
        if (INTERACTIVE && dataType == 0 && TEST_SELECTOR.intValue() == testSelect.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            destinationIMG.getTiles();
        }
        Assert.assertTrue((destinationIMG.getHeight() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((destinationIMG.getWidth() > 0 ? 1 : 0) != 0);
        Rectangle inputRect = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        Rectangle outputRect = warpObj.mapSourceRect(inputRect);
        Assert.assertEquals((long)destinationIMG.getMinX(), (long)outputRect.x);
        Assert.assertEquals((long)destinationIMG.getMinY(), (long)outputRect.y);
        Assert.assertEquals((long)destinationIMG.getHeight(), (long)outputRect.width);
        Assert.assertEquals((long)destinationIMG.getWidth(), (long)outputRect.height);
        if (roiUsed) {
            Object roiProperty = destinationIMG.getProperty("ROI");
            Assert.assertThat((Object)roiProperty, (Matcher)CoreMatchers.instanceOf(ROI.class));
            ROI destRoi = (ROI)roiProperty;
            PlanarImage roiImage = destRoi.getAsImage();
            Assert.assertThat((Object)roiImage, (Matcher)CoreMatchers.instanceOf(RenderedOp.class));
            RenderedOp roiOp = (RenderedOp)roiImage;
            switch (interpType) {
                case NEAREST_INTERP: {
                    Assert.assertThat((Object)this.getWarpOperation(roiOp), (Matcher)CoreMatchers.instanceOf(WarpNearestOpImage.class));
                    break;
                }
                case BILINEAR_INTERP: {
                    Assert.assertThat((Object)this.getWarpOperation(roiOp), (Matcher)CoreMatchers.instanceOf(WarpBilinearOpImage.class));
                    break;
                }
                case BICUBIC_INTERP: 
                case GENERAL_INTERP: {
                    Assert.assertThat((Object)this.getWarpOperation(roiOp), (Matcher)CoreMatchers.instanceOf(WarpBicubicOpImage.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong interpolation type");
                }
            }
        }
        this.destinationNoData = 10.0;
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.MEAN};
        switch (dataType) {
            case 0: {
                noData = RangeFactory.create((byte)((byte)this.destinationNoData), (boolean)true, (byte)((byte)this.destinationNoData), (boolean)true);
                break;
            }
            case 1: 
            case 2: {
                noData = RangeFactory.create((short)((short)this.destinationNoData), (boolean)true, (short)((short)this.destinationNoData), (boolean)true);
                break;
            }
            case 3: {
                noData = RangeFactory.create((int)((int)this.destinationNoData), (boolean)true, (int)((int)this.destinationNoData), (boolean)true);
                break;
            }
            case 4: {
                noData = RangeFactory.create((float)((float)this.destinationNoData), (boolean)true, (float)((float)this.destinationNoData), (boolean)true, (boolean)true);
                break;
            }
            case 5: {
                noData = RangeFactory.create((double)this.destinationNoData, (boolean)true, (double)this.destinationNoData, (boolean)true, (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        RenderedOp statistics = StatisticsDescriptor.create((RenderedImage)destinationIMG, (int)1, (int)1, (ROI)roi, (Range)noData, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])stats, null, null, null, (RenderingHints)hints);
        Statistics[][] result = (Statistics[][])statistics.getProperty("JAI-EXT.stats");
        destinationIMG.dispose();
        double mean = (Double)result[0][0].getResult();
        long num = result[0][0].getNumSamples();
        Assert.assertTrue((num > 0L ? 1 : 0) != 0);
        Assert.assertTrue((mean != this.destinationNoData ? 1 : 0) != 0);
        statistics.dispose();
    }

    private RenderedImage getWarpOperation(RenderedOp roiOp) {
        String name = roiOp.getOperationName();
        if ("binarize".equals(name)) {
            return roiOp.getSourceImage(0);
        }
        return roiOp.getRendering();
    }

    public void testImage(TestBase.InterpolationType interpType) {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        TestBase.TestSelection testSelect = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        for (int i = 0; i < images.length; ++i) {
            this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        }
    }

    public void testImageROI(TestBase.InterpolationType interpType) {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        TestBase.TestSelection testSelect = TestBase.TestSelection.ROI_ONLY_DATA;
        for (int i = 0; i < images.length; ++i) {
            this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        }
    }

    public void testImageNoData(TestBase.InterpolationType interpType) {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        TestBase.TestSelection testSelect = TestBase.TestSelection.NO_ROI_NO_DATA;
        for (int i = 0; i < images.length; ++i) {
            this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        }
    }

    public void testImageNoDataROI(TestBase.InterpolationType interpType) {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        TestBase.TestSelection testSelect = TestBase.TestSelection.ROI_NO_DATA;
        for (int i = 0; i < images.length; ++i) {
            this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        }
    }

    public static void finalStuff() {
        if (images != null) {
            for (int i = 0; i < images.length; ++i) {
                RenderedImage image = images[i];
                if (image instanceof TiledImage) {
                    ((TiledImage)image).dispose();
                    continue;
                }
                if (!(image instanceof BufferedImage)) continue;
                ((BufferedImage)image).flush();
            }
        }
    }

    protected void testROILayout(int interpolation) {
        this.testROILayout(0, interpolation);
        this.testROILayout(1, interpolation);
        this.testROILayout(2, interpolation);
        this.testROILayout(3, interpolation);
        this.testROILayout(4, interpolation);
        this.testROILayout(5, interpolation);
    }

    protected void testROILayout(int dataType, int interpolationType) {
        RenderedImage testIMG = TestWarp.createTestImage((int)dataType, (int)1, (int)1, null, (boolean)false);
        PlanarImage testImgWithROI = PlanarImage.wrapRenderedImage((RenderedImage)testIMG);
        ROIShape roi = new ROIShape((Shape)new Rectangle(0, 0, 1, 1));
        testImgWithROI.setProperty("roi", (Object)roi);
        ImageLayout targetLayout = new ImageLayout();
        targetLayout.setTileWidth(512);
        targetLayout.setTileHeight(512);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, targetLayout);
        RenderedOp warped = WarpDescriptor.create((RenderedImage)testIMG, (Warp)new WarpAffine(new AffineTransform(1.0f, -1.0f, 1.0f, 1.0f, 0.0f, 0.0f)), (Interpolation)Interpolation.getInstance((int)interpolationType), null, (ROI)roi, (RenderingHints)hints);
        ROI warpedROI = (ROI)warped.getProperty("roi");
        Assert.assertEquals((Object)warped.getBounds(), (Object)warpedROI.getBounds());
        PlanarImage scaleRoiImage = warpedROI.getAsImage();
        Assert.assertEquals((long)warped.getTileHeight(), (long)scaleRoiImage.getTileHeight());
        Assert.assertEquals((long)warped.getTileWidth(), (long)scaleRoiImage.getTileWidth());
        Assert.assertEquals((long)512L, (long)scaleRoiImage.getTileWidth());
        Assert.assertEquals((long)512L, (long)scaleRoiImage.getTileHeight());
    }
}

