/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.warp.TestWarp;
import it.geosolutions.jaiext.warp.WarpNearestOpImage;
import java.awt.geom.AffineTransform;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.Interpolation;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NearestWarpTest
extends TestWarp {
    @BeforeClass
    public static void setup() {
        JAIExt.initJAIEXT();
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(45.0));
        transform.concatenate(AffineTransform.getTranslateInstance(0.0, -DEFAULT_HEIGHT));
        warpObj = new WarpAffine(transform);
        noDataValueB = (byte)55;
        noDataValueU = (short)55;
        noDataValueS = (short)55;
        noDataValueI = 55;
        noDataValueF = 55.0f;
        noDataValueD = 55.0;
        images = new RenderedImage[6];
        boolean imageToFill = IMAGE_FILLER;
        IMAGE_FILLER = true;
        NearestWarpTest.images[0] = NearestWarpTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataValueB, (boolean)false);
        NearestWarpTest.images[1] = NearestWarpTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataValueU, (boolean)false);
        NearestWarpTest.images[2] = NearestWarpTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataValueS, (boolean)false);
        NearestWarpTest.images[3] = NearestWarpTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataValueI, (boolean)false);
        NearestWarpTest.images[4] = NearestWarpTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataValueF), (boolean)false);
        NearestWarpTest.images[5] = NearestWarpTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataValueD, (boolean)false);
        IMAGE_FILLER = imageToFill;
        interpType = TestBase.InterpolationType.NEAREST_INTERP;
    }

    @Test
    public void testImage() {
        super.testImage(interpType);
    }

    @Test
    public void testImageROI() {
        super.testImageROI(interpType);
    }

    @Test
    public void testImageNoData() {
        super.testImageNoData(interpType);
    }

    @Test
    public void testImageNoDataROI() {
        super.testImageNoDataROI(interpType);
    }

    @Test
    public void testROIIntersect() {
        int width = 48000;
        int height = 36000;
        int tileSize = 128;
        int tileX = 373;
        int tileY = 279;
        int pixelsInTiles = 16384;
        int[] pixelValue = new int[16384];
        double backgroundValue = 99.0;
        int validValue = 50;
        ComponentSampleModel tileSampleModel = new ComponentSampleModel(0, 48000, 36000, 1, 48000, new int[]{0});
        TiledImage source = new TiledImage((SampleModel)tileSampleModel, 128, 128);
        WritableRaster rasterTile = (WritableRaster)source.getTile(373, 278);
        Arrays.fill(pixelValue, 50);
        rasterTile.setPixels(47744, 35584, 128, 128, pixelValue);
        rasterTile = (WritableRaster)source.getTile(372, 278);
        rasterTile.setPixels(47616, 35584, 128, 128, pixelValue);
        int roiWidth = 47744;
        int roiHeight = 35712;
        RenderedOp roiSource = ConstantDescriptor.create((Float)Float.valueOf(47744.0f), (Float)Float.valueOf(35712.0f), (Number[])new Integer[]{255}, null);
        ROI roi = new ROI((RenderedImage)roiSource);
        WarpNearestOpImage warpImage = new WarpNearestOpImage((RenderedImage)source, null, null, (Warp)new WarpAffine(new AffineTransform()), Interpolation.getInstance((int)0), roi, null, new double[]{99.0});
        long memBefore = Runtime.getRuntime().freeMemory() / 0x100000L;
        long start = System.nanoTime();
        boolean outOfMemory = false;
        Raster outsideRoi = null;
        Raster insideRoi = null;
        try {
            outsideRoi = warpImage.getTile(373, 278);
            insideRoi = warpImage.getTile(372, 278);
        }
        catch (OutOfMemoryError oom) {
            outOfMemory = true;
        }
        long elapsedTimeInMilliseconds = (System.nanoTime() - start) / 1000000L;
        long memAfter = Runtime.getRuntime().freeMemory() / 0x100000L;
        Assert.assertTrue((!outOfMemory && (elapsedTimeInMilliseconds < 500L || Math.abs(memAfter - memBefore) < 10L) ? 1 : 0) != 0);
        byte[] pixelsInsideRoi = new byte[16384];
        byte[] pixelsOutsideRoi = new byte[16384];
        outsideRoi.getDataElements(47744, 35584, 128, 128, pixelsOutsideRoi);
        insideRoi.getDataElements(47616, 35584, 128, 128, pixelsInsideRoi);
        int backgroundPixels = 0;
        int validPixels = 0;
        for (int i = 0; i < 16384; ++i) {
            backgroundPixels += (double)pixelsOutsideRoi[i] == 99.0 ? 1 : 0;
            validPixels += pixelsInsideRoi[i] == 50 ? 1 : 0;
        }
        Assert.assertTrue((backgroundPixels == 16384 ? 1 : 0) != 0);
        Assert.assertTrue((validPixels == 16384 ? 1 : 0) != 0);
    }

    @AfterClass
    public static void finalStuff() {
        TestWarp.finalStuff();
    }

    @Test
    public void testROILayout() {
        this.testROILayout(0);
    }
}

