/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.rest.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import it.geosolutions.mapstore.controllers.BaseMapStoreController;
import it.geosolutions.mapstore.utils.ResourceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UploadPluginController
extends BaseMapStoreController {
    private ObjectMapper jsonMapper = new ObjectMapper();
    private JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(false);
    @Autowired
    ServletContext context;

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/uploadPlugin"}, method={RequestMethod.POST}, headers={"Accept=application/json"})
    @ResponseBody
    public String uploadPlugin(InputStream dataStream) throws IOException {
        ZipInputStream zip = new ZipInputStream(dataStream);
        ZipEntry entry = zip.getNextEntry();
        String pluginName = null;
        String bundleName = null;
        HashMap<File, String> tempFiles = new HashMap<File, String>();
        JsonNode plugin = null;
        boolean addTranslations = false;
        while (entry != null) {
            if (!entry.isDirectory()) {
                File tempAsset;
                if (entry.getName().toLowerCase().endsWith("index.js")) {
                    bundleName = entry.getName();
                    File tempBundle = File.createTempFile("mapstore-bundle", ".js");
                    this.storeAsset(zip, tempBundle);
                    tempFiles.put(tempBundle, "js");
                }
                if ("index.json".equals(entry.getName().toLowerCase())) {
                    JsonNode json = this.readJSON(zip);
                    JsonNode plugins = json.get("plugins");
                    plugin = plugins.get(0);
                    ((ObjectNode)plugin).put("extension", true);
                    pluginName = plugin.get("name").asText();
                    if (this.shouldStorePluginsConfigAsPatch()) {
                        this.addPluginConfigurationAsPatch(plugin);
                    } else {
                        this.addPluginConfiguration(plugin);
                    }
                }
                if (entry.getName().toLowerCase().startsWith("translations/")) {
                    tempAsset = File.createTempFile("mapstore-asset-translations", ".json");
                    this.storeAsset(zip, tempAsset);
                    tempFiles.put(tempAsset, "asset/" + entry.getName());
                    addTranslations = true;
                }
                if (entry.getName().toLowerCase().startsWith("assets/")) {
                    tempAsset = File.createTempFile(entry.getName(), ".tmp");
                    this.storeAsset(zip, tempAsset);
                    tempFiles.put(tempAsset, "asset/" + entry.getName());
                }
            }
            entry = zip.getNextEntry();
        }
        String pluginBundle = pluginName + "/" + bundleName;
        String translations = addTranslations ? pluginName + "/translations" : null;
        this.addExtension(pluginName, pluginBundle, translations);
        for (File tempFile : tempFiles.keySet()) {
            String type = (String)tempFiles.get(tempFile);
            if ("js".equals(type)) {
                this.moveAsset(tempFile, this.getExtensionsFolder() + "/" + pluginBundle);
            }
            if (type.indexOf("asset/") != 0) continue;
            String assetPath = this.getExtensionsFolder() + "/" + pluginName + "/" + type.substring(type.indexOf("/") + 1);
            this.moveAsset(tempFile, assetPath);
        }
        zip.close();
        if (plugin == null) {
            throw new IOException("Invalid bundle: index.json missing");
        }
        return plugin.toString();
    }

    private boolean shouldStorePluginsConfigAsPatch() {
        return this.getPluginsConfigAsPatch() != false && this.canUseDataDir();
    }

    private boolean canUseDataDir() {
        return this.getDataDir().isEmpty() ? false : Stream.of(this.getDataDir().split(",")).filter(new Predicate<String>(){

            @Override
            public boolean test(String folder) {
                return !folder.trim().isEmpty() && new File(folder).exists();
            }
        }).count() > 0L;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/uninstallPlugin/{pluginName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public String uninstallPlugin(@PathVariable String pluginName) throws IOException {
        String key;
        ObjectNode configObj = this.getExtensionConfig();
        if (configObj.has(key = pluginName)) {
            ArrayNode plugins;
            JsonNode pluginConfig = configObj.get(key);
            String pluginBundle = pluginConfig.get("bundle").asText();
            String pluginFolder = pluginBundle.substring(0, pluginBundle.lastIndexOf("/"));
            this.removeFolder(Paths.get(this.getExtensionsFolder(), pluginFolder).toString());
            configObj.remove(key);
            this.storeJSONConfig(configObj, this.getExtensionsConfigPath());
            ObjectNode pluginsConfigObj = null;
            if (this.shouldStorePluginsConfigAsPatch()) {
                plugins = this.getPluginsConfigurationPatch();
            } else {
                pluginsConfigObj = this.getPluginsConfiguration();
                plugins = (ArrayNode)pluginsConfigObj.get("plugins");
            }
            int toRemove = -1;
            for (int i = 0; i < plugins.size(); ++i) {
                String name;
                JsonNode plugin = plugins.get(i);
                String string = name = plugin.has("name") ? plugin.get("name").asText() : plugin.get("value").get("name").asText();
                if (!name.contentEquals(pluginName)) continue;
                toRemove = i;
            }
            if (toRemove >= 0) {
                plugins.remove(toRemove);
            }
            if (this.shouldStorePluginsConfigAsPatch()) {
                this.storeJSONConfig(plugins, this.getPluginsConfigPatchFilePath());
            } else {
                this.storeJSONConfig(pluginsConfigObj, this.getPluginsConfig());
            }
            return pluginConfig.toString();
        }
        return "{}";
    }

    private void removeFolder(String pluginFolder) throws IOException {
        File folderPath = new File(ResourceUtils.getResourcePath(this.getWriteStorage(), this.context, pluginFolder));
        if (folderPath.exists()) {
            FileUtils.cleanDirectory((File)folderPath);
            folderPath.delete();
        }
    }

    private Optional<File> findResource(String resourceName) {
        return ResourceUtils.findResource(this.getDataDir(), this.context, resourceName);
    }

    private void moveAsset(File tempAsset, String finalAsset) throws FileNotFoundException, IOException {
        String assetPath = ResourceUtils.getResourcePath(this.getWriteStorage(), this.context, finalAsset);
        new File(assetPath).getParentFile().mkdirs();
        try (FileInputStream input = new FileInputStream(tempAsset);
             FileOutputStream output = new FileOutputStream(assetPath);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        tempAsset.delete();
    }

    private String getWriteStorage() {
        return this.getDataDir().isEmpty() ? "" : Stream.of(this.getDataDir().split(",")).filter(new Predicate<String>(){

            @Override
            public boolean test(String folder) {
                return !folder.trim().isEmpty();
            }
        }).findFirst().orElse("");
    }

    private void addPluginConfiguration(JsonNode json) throws IOException {
        ObjectNode config = null;
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                config = (ObjectNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.objectNode();
                config.set("plugins", (JsonNode)this.jsonNodeFactory.arrayNode());
            }
        } else {
            config = this.jsonNodeFactory.objectNode();
            config.set("plugins", (JsonNode)this.jsonNodeFactory.arrayNode());
        }
        if (config != null) {
            ArrayNode plugins = (ArrayNode)config.get("plugins");
            int remove = -1;
            for (int count = 0; count < plugins.size(); ++count) {
                JsonNode node = plugins.get(count);
                if (!json.get("name").asText().equals(node.get("name").asText())) continue;
                remove = count;
            }
            if (remove >= 0) {
                plugins.remove(remove);
            }
            plugins.add(json);
            this.storeJSONConfig(config, this.getPluginsConfigPath());
        }
    }

    private void addPluginConfigurationAsPatch(JsonNode json) throws IOException {
        ArrayNode config = null;
        String configPath = this.getPluginsConfigPatchFilePath();
        Optional<File> pluginsConfigFile = this.findResource(configPath);
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                config = (ArrayNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.arrayNode();
            }
        } else {
            config = this.jsonNodeFactory.arrayNode();
        }
        if (config != null) {
            int remove = -1;
            for (int count = 0; count < config.size(); ++count) {
                JsonNode node = config.get(count);
                if (!json.get("name").asText().equals(node.get("value").get("name").asText())) continue;
                remove = count;
            }
            if (remove >= 0) {
                config.remove(remove);
            }
            ObjectNode plugin = new ObjectNode(this.jsonNodeFactory);
            plugin.put("op", "add");
            plugin.put("path", "/plugins/-");
            plugin.set("value", json);
            config.add((JsonNode)plugin);
            this.storeJSONConfig(config, configPath);
        }
    }

    private ObjectNode getPluginsConfiguration() throws IOException {
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                ObjectNode objectNode = (ObjectNode)this.readJSON(input);
                return objectNode;
            }
        }
        throw new FileNotFoundException(this.getPluginsConfigPath());
    }

    private ArrayNode getPluginsConfigurationPatch() throws IOException {
        Optional<File> pluginsConfigFile = this.findResource(this.getPluginsConfigPatchFilePath());
        if (pluginsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(pluginsConfigFile.get());){
                ArrayNode arrayNode = (ArrayNode)this.readJSON(input);
                return arrayNode;
            }
        }
        throw new FileNotFoundException(this.getPluginsConfigPatchFilePath());
    }

    private void storeJSONConfig(Object config, String configName) throws FileNotFoundException, IOException {
        ResourceUtils.storeJSONConfig(this.getWriteStorage(), this.context, config, configName);
    }

    private void addExtension(String pluginName, String pluginBundle, String translations) throws FileNotFoundException, IOException {
        ObjectNode config = null;
        Optional<File> extensionsConfigFile = this.findResource(this.getExtensionsConfigPath());
        if (extensionsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(extensionsConfigFile.get());){
                config = (ObjectNode)this.readJSON(input);
            }
            catch (FileNotFoundException e) {
                config = this.jsonNodeFactory.objectNode();
            }
        } else {
            config = this.jsonNodeFactory.objectNode();
        }
        if (config != null) {
            ObjectNode extension = this.jsonNodeFactory.objectNode();
            extension.put("bundle", pluginBundle);
            if (translations != null) {
                extension.put("translations", translations);
            }
            if (config.has(pluginName)) {
                config.replace(pluginName, (JsonNode)extension);
            } else {
                config.set(pluginName, (JsonNode)extension);
            }
            this.storeJSONConfig(config, this.getExtensionsConfigPath());
        }
    }

    private ObjectNode getExtensionConfig() throws IOException {
        Optional<File> extensionsConfigFile = this.findResource(this.getExtensionsConfigPath());
        if (extensionsConfigFile.isPresent()) {
            try (FileInputStream input = new FileInputStream(extensionsConfigFile.get());){
                ObjectNode objectNode = (ObjectNode)this.readJSON(input);
                return objectNode;
            }
        }
        throw new FileNotFoundException();
    }

    private JsonNode readJSON(InputStream input) throws IOException {
        byte[] buffer = new byte[1024];
        int read = 0;
        StringBuilder json = new StringBuilder();
        while ((read = input.read(buffer, 0, 1024)) >= 0) {
            json.append(new String(buffer, 0, read));
        }
        return this.jsonMapper.readTree(json.toString());
    }

    private void storeAsset(ZipInputStream zip, File file) throws FileNotFoundException, IOException {
        try (FileOutputStream outFile = new FileOutputStream(file);){
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = zip.read(buffer, 0, 1024)) >= 0) {
                outFile.write(buffer, 0, read);
            }
        }
    }

    @Override
    public void setContext(ServletContext context) {
        this.context = context;
    }

    private String getExtensionsConfigPath() {
        return Paths.get(this.getExtensionsFolder(), this.getExtensionsConfig()).toString();
    }

    private String getPluginsConfigPath() {
        return Paths.get(this.getConfigsFolder(), this.getPluginsConfig()).toString();
    }

    private String getPluginsConfigPatchFilePath() {
        return this.getPluginsConfigPath() + ".patch";
    }
}

