/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.dggs.clickhouse.ClickHouseDateTestSetup;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ClickHouseDateOnlineTest
extends JDBCTestSupport {
    protected JDBCTestSetup createTestSetup() {
        return new ClickHouseDateTestSetup();
    }

    protected Map<String, Object> createDataStoreFactoryParams() throws Exception {
        Map params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.SCHEMA.key, params.get(JDBCDataStoreFactory.DATABASE.key));
        return params;
    }

    @Test
    public void testReadData() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures());
        java.util.Date date = (java.util.Date)f.getAttribute(this.aname("d"));
        Assert.assertNotNull((Object)date);
        Timestamp timestamp = (Timestamp)f.getAttribute(this.aname("dt"));
        Assert.assertNotNull((Object)timestamp);
    }

    @Test
    public void testMappings() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("dates"));
        Assert.assertEquals(Date.class, (Object)ft.getDescriptor(this.aname("d")).getType().getBinding());
        Assert.assertEquals(Timestamp.class, (Object)ft.getDescriptor(this.aname("dt")).getType().getBinding());
    }

    @Test
    public void testFiltersByDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)df.parse("2009-06-28")));
        Assert.assertEquals((long)2L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterByTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-dd-MM");
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone[] zones = new TimeZone[]{TimeZone.getTimeZone("Etc/GMT+12"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("America/New_York"), TimeZone.getTimeZone("Etc/GMT"), TimeZone.getTimeZone("Europe/Berlin"), TimeZone.getTimeZone("Etc/GMT-12"), TimeZone.getTimeZone("Etc/GMT-14")};
        try {
            for (TimeZone zone : zones) {
                TimeZone.setDefault(zone);
                ((ClickHouseDateTestSetup)this.setup).setUpData();
                df.setTimeZone(zone);
                PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-06-28 15:12:41"));
                Assert.assertEquals((long)1L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
            }
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
            ((ClickHouseDateTestSetup)this.setup).setUpData();
        }
    }

    @Test
    public void testMinDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        MinVisitor visitor = new MinVisitor(this.aname("d"));
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        java.util.Date date = (java.util.Date)visitor.getMin();
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void testMaxDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        MaxVisitor visitor = new MaxVisitor(this.aname("d"));
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        java.util.Date date = (java.util.Date)visitor.getMax();
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void testDistinctDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        UniqueVisitor visitor = new UniqueVisitor(new String[]{this.aname("d")});
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        Set results = visitor.getUnique();
        for (Object result : results) {
            MatcherAssert.assertThat(result, (Matcher)CoreMatchers.instanceOf(java.util.Date.class));
        }
    }

    @Test
    public void testNearestDate() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        NearestVisitor visitor = new NearestVisitor((Expression)ff.property(this.aname("d")), (Object)new java.util.Date());
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        java.util.Date date = (java.util.Date)visitor.getNearestMatch();
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void testMinTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        MinVisitor visitor = new MinVisitor(this.aname("dt"));
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        Timestamp ts = (Timestamp)visitor.getMin();
        Assert.assertNotNull((Object)ts);
    }

    @Test
    public void testMaxTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        MaxVisitor visitor = new MaxVisitor(this.aname("dt"));
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        Timestamp ts = (Timestamp)visitor.getMax();
        Assert.assertNotNull((Object)ts);
    }

    @Test
    public void testDistinctTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        UniqueVisitor visitor = new UniqueVisitor(new String[]{this.aname("dt")});
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        Set results = visitor.getUnique();
        for (Object result : results) {
            MatcherAssert.assertThat(result, (Matcher)CoreMatchers.instanceOf(Timestamp.class));
        }
    }

    @Test
    public void testNearestTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        NearestVisitor visitor = new NearestVisitor((Expression)ff.property(this.aname("dt")), (Object)new Timestamp(System.currentTimeMillis()));
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        Timestamp ts = (Timestamp)visitor.getNearestMatch();
        Assert.assertNotNull((Object)ts);
    }
}

