/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickHouseDGGStoreFactory;
import org.geotools.dggs.clickhouse.ClickHouseRHealPixOnlineTest;
import org.geotools.jdbc.JDBCJNDIDataStoreFactory;
import org.geotools.util.factory.GeoTools;
import org.mockito.Mockito;

public class ClickHouseJNDIRHealPixOnlineTest
extends ClickHouseRHealPixOnlineTest {
    @Override
    protected ClickHouseDGGSDataStore getDataStore() throws Exception {
        String dggsId = this.getDGGSId();
        if (!DGGSFactoryFinder.getFactory((String)dggsId).isPresent()) {
            throw new Exception(dggsId + " is not present, skipping the test");
        }
        ClickHouseDGGStoreFactory factory = new ClickHouseDGGStoreFactory();
        BasicDataSource dataSource = (BasicDataSource)factory.createDataSource((Map)this.fixture);
        MockInitialDirContextFactory.setDataSource(dataSource);
        System.setProperty("java.naming.factory.initial", MockInitialDirContextFactory.class.getName());
        try {
            GeoTools.clearInitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(JDBCJNDIDataStoreFactory.DBTYPE.key, "clickhouse");
        params.put(JDBCJNDIDataStoreFactory.JNDI_REFNAME.key, "ds");
        params.put(ClickHouseDGGStoreFactory.DGGS_FACTORY_ID.key, dggsId);
        return (ClickHouseDGGSDataStore)DataStoreFinder.getDataStore(params);
    }

    public static class MockInitialDirContextFactory
    implements InitialContextFactory {
        private Context mockContext = null;
        private static BasicDataSource dataSource;

        public static void setDataSource(BasicDataSource dataSource) {
            MockInitialDirContextFactory.dataSource = dataSource;
        }

        public Context getInitialContext(Hashtable environment) throws NamingException {
            this.mockContext = (Context)Mockito.mock(Context.class);
            Mockito.when((Object)this.mockContext.lookup("ds")).thenReturn((Object)dataSource);
            return this.mockContext;
        }
    }
}

