/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickHouseDGGStoreFactory;
import org.geotools.test.OnlineTestCase;
import org.geotools.util.logging.Logging;

public abstract class ClickHouseOnlineTestCase
extends OnlineTestCase {
    static final Logger LOGGER = Logging.getLogger(ClickHouseOnlineTestCase.class);
    protected ClickHouseDGGSDataStore dataStore;

    protected void connect() throws Exception {
        this.dataStore = this.getDataStore();
        this.setupTestData(this.dataStore);
    }

    protected abstract void setupTestData(ClickHouseDGGSDataStore var1) throws Exception;

    protected ClickHouseDGGSDataStore getDataStore() throws Exception {
        String dggsId = this.getDGGSId();
        if (!DGGSFactoryFinder.getFactory((String)dggsId).isPresent()) {
            throw new Exception(dggsId + " is not present, skipping the test");
        }
        ClickHouseDGGStoreFactory factory = new ClickHouseDGGStoreFactory();
        Properties params = this.fixture;
        return (ClickHouseDGGSDataStore)factory.createDataStore((Map)params);
    }

    protected boolean isOnline() {
        String dggsId = this.getDGGSId();
        boolean present = DGGSFactoryFinder.getFactory((String)dggsId).isPresent();
        if (!present) {
            LOGGER.log(Level.WARNING, dggsId + " is not present, skipping the test");
        }
        return present;
    }

    protected Properties createExampleFixture() {
        Properties fixture = new Properties();
        fixture.put("driver", "com.clickhouse.jdbc.ClickHouseDriver");
        fixture.put("url", "jdbc:clickhouse://localhost:8123/test");
        fixture.put("host", "localhost");
        fixture.put("database", "test");
        fixture.put("port", "8123");
        fixture.put("user", "default");
        fixture.put("password", "");
        fixture.put(ClickHouseDGGStoreFactory.DGGS_FACTORY_ID.key, this.getDGGSId());
        return fixture;
    }

    protected abstract String getDGGSId();

    protected String getFixtureId() {
        return "clickhouse-dggs-" + this.getDGGSId();
    }
}

