/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickHouseJDBCDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class ClickHouseDGGStoreFactory
implements DataStoreFactorySpi {
    JDBCDataStoreFactory delegate = new ClickHouseJDBCDataStoreFactory();
    public static final DataAccessFactory.Param DGGS_FACTORY_ID = new DataAccessFactory.Param("dggs_id", String.class, "DGGS Factory identifier, e.g., H3 or rHEALPix", true, null);

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.createDataStore(params);
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        HashMap delegateParams = new HashMap(params);
        delegateParams.put(JDBCDataStoreFactory.DBTYPE.key, "clickhouse");
        delegateParams.put(JDBCDataStoreFactory.SCHEMA.key, params.get(JDBCDataStoreFactory.DATABASE.key));
        JDBCDataStore jdbcStore = this.delegate.createDataStore(delegateParams);
        String factoryId = (String)DGGS_FACTORY_ID.lookUp(params);
        DGGSInstance instance = DGGSFactoryFinder.createInstance((String)factoryId, params);
        return new ClickHouseDGGSDataStore(instance, (DataStore)jdbcStore);
    }

    public String getDisplayName() {
        return "ClickHouse DGGS integration";
    }

    public String getDescription() {
        return "ClickHouse DGGS integration";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        Stream<DataAccessFactory.Param> delegateParams = Stream.of(this.delegate.getParametersInfo()).filter(p -> !JDBCDataStoreFactory.DBTYPE.key.equals(p.key) && !JDBCDataStoreFactory.SCHEMA.key.equals(p.key));
        return (DataAccessFactory.Param[])Stream.concat(Stream.of(DGGS_FACTORY_ID), delegateParams).toArray(DataAccessFactory.Param[]::new);
    }

    public boolean isAvailable() {
        return this.delegate.isAvailable() && DGGSFactoryFinder.getExtensionFactories().findAny().isPresent();
    }

    protected DataSource createDataSource(Map<String, ?> params) throws IOException {
        return this.delegate.createDataSource(params);
    }
}

