/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.dggs.GroupedMatrixAggregate;
import org.geotools.dggs.MatrixAggregate;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;

public class ClickhouseAggregatorCollection
extends DecoratingSimpleFeatureCollection {
    static final Logger LOGGER = Logging.getLogger(ClickhouseAggregatorCollection.class);
    private final SimpleFeatureType featureType;
    private final Query query;
    private final JDBCDataStore store;

    public ClickhouseAggregatorCollection(SimpleFeatureCollection delegate, JDBCDataStore store, Query query, SimpleFeatureType featureType) {
        super(delegate);
        this.store = store;
        this.query = query;
        this.featureType = featureType;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (visitor instanceof MatrixAggregate ? this.visit((MatrixAggregate)visitor) : visitor instanceof GroupedMatrixAggregate && this.visit((GroupedMatrixAggregate)visitor)) {
            return;
        }
        this.delegate.accepts(visitor, progress);
    }

    /*
     * Exception decompiling
     */
    private boolean visit(MatrixAggregate visitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean visit(GroupedMatrixAggregate visitor) throws IOException {
        try {
            List calculators = visitor.getCalculators();
            for (FeatureCalc fc : calculators) {
                if (this.matchAggregateFunction((FeatureVisitor)fc) != null) continue;
                return false;
            }
            SQLDialect dialect = this.store.getSQLDialect();
            FilterToSQL f2s = this.createFilterToSQL(this.featureType);
            f2s.setInline(true);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            List groupByExpressions = visitor.getGroupBy();
            for (Expression groupBy : groupByExpressions) {
                sql.append(f2s.encodeToString(groupBy));
                sql.append(", ");
            }
            for (FeatureCalc fc : calculators) {
                String function = this.matchAggregateFunction((FeatureVisitor)fc);
                sql.append(function).append("(");
                Expression expression = this.getExpression((FeatureVisitor)fc);
                if (expression == null) {
                    sql.append("*");
                } else {
                    sql.append(f2s.encodeToString(expression));
                }
                sql.append("), ");
            }
            sql.setLength(sql.length() - 2);
            sql.append(" FROM ");
            if (this.store.getDatabaseSchema() != null) {
                dialect.encodeSchemaName(this.store.getDatabaseSchema(), sql);
                sql.append(".");
            }
            dialect.encodeTableName(this.featureType.getTypeName(), sql);
            Filter filter = this.query.getFilter();
            if (filter != Filter.INCLUDE) {
                sql.append(" WHERE ");
                sql.append(f2s.encodeToString(filter));
            }
            sql.append(" GROUP BY ");
            for (Expression groupBy : groupByExpressions) {
                sql.append(f2s.encodeToString(groupBy));
                sql.append(", ");
            }
            sql.setLength(sql.length() - 2);
            visitor.setResults((CalcResult)new GroupedMatrixAggregate.IterableResult(() -> new GroupedIterableResult(this.store, sql, groupByExpressions.size(), calculators.size())));
            return true;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FilterToSQL createFilterToSQL(SimpleFeatureType featureType) {
        return this.initializeFilterToSQL(((BasicSQLDialect)this.store.getSQLDialect()).createFilterToSQL(), featureType);
    }

    protected <F extends FilterToSQL> F initializeFilterToSQL(F toSQL, SimpleFeatureType featureType) {
        toSQL.setSqlNameEscape(this.store.getSQLDialect().getNameEscape());
        if (featureType != null) {
            PrimaryKey key;
            try {
                key = this.store.getPrimaryKey(featureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            toSQL.setFeatureType(featureType);
            toSQL.setPrimaryKey(key);
            toSQL.setDatabaseSchema(this.store.getDatabaseSchema());
        }
        return toSQL;
    }

    protected String matchAggregateFunction(FeatureVisitor visitor) {
        String function = null;
        for (Class<?> visitorClass = visitor.getClass(); function == null && visitorClass != null; visitorClass = visitorClass.getSuperclass()) {
            function = (String)this.store.getAggregateFunctions().get(visitorClass);
        }
        if (function == null) {
            LOGGER.info("Unable to find aggregate function matching visitor: " + visitor.getClass());
        }
        return function;
    }

    Expression getExpression(FeatureVisitor visitor) {
        if (visitor instanceof CountVisitor) {
            return null;
        }
        try {
            Object result;
            Method g = visitor.getClass().getMethod("getExpression", null);
            if (g != null && (result = g.invoke((Object)visitor, null)) instanceof Expression) {
                return (Expression)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class GroupedIterableResult
    implements CloseableIterator<GroupedMatrixAggregate.GroupByResult> {
        Connection cx;
        Statement st;
        ResultSet rs;
        Boolean next;
        int groupSize;
        int resultSize;

        public GroupedIterableResult(JDBCDataStore store, StringBuffer sql, int groupSize, int resultSize) {
            try {
                this.cx = store.getConnection(Transaction.AUTO_COMMIT);
                this.st = this.cx.createStatement();
                this.rs = this.st.executeQuery(sql.toString());
                this.groupSize = groupSize;
                this.resultSize = resultSize;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void close() throws IOException {
            try {
                try {
                    if (this.rs != null) {
                        this.rs.close();
                    }
                }
                finally {
                    try {
                        if (this.st != null) {
                            this.st.close();
                        }
                    }
                    finally {
                        if (this.cx != null) {
                            this.cx.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.rs.next();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.SEVERE, "Failed to compute next aggregation result", e);
                    return false;
                }
            }
            return this.next;
        }

        public GroupedMatrixAggregate.GroupByResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.next = null;
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                for (int i = 0; i < this.groupSize; ++i) {
                    key.add(this.rs.getObject(i + 1));
                }
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < this.resultSize; ++i) {
                    values.add(this.rs.getObject(this.groupSize + i + 1));
                }
                return new GroupedMatrixAggregate.GroupByResult(key, values);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

