/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.dggs.clickhouse.ClickHouseFilterToSQL;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClickHouseFilterToSQLTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    private static TimeZone defaultTimeZone;

    @BeforeClass
    public static void getDefaultTimeZone() {
        defaultTimeZone = TimeZone.getDefault();
    }

    @AfterClass
    public static void resetDefaultTimeZone() {
        TimeZone.setDefault(defaultTimeZone);
    }

    @Test
    public void testDateComparisonUTC() throws Exception {
        this.testDateComparison("UTC", "2023-04-01 00:00:00", "WHERE myDateField = parseDateTimeBestEffort('2023-04-01T00:00:00.000Z')");
    }

    @Test
    public void testDateComparisonCET() throws Exception {
        this.testDateComparison("CET", "2023-04-01 00:00:00", "WHERE myDateField = parseDateTimeBestEffort('2023-04-01T00:00:00.000+02:00')");
    }

    private void testDateComparison(String timeZoneId, String dateString, String expectedSql) throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone(timeZoneId));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = dateFormat.parse(dateString);
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.property("myDateField"), (Expression)this.ff.literal((Object)startDate));
        ClickHouseFilterToSQL clickHouseFilterToSQL = new ClickHouseFilterToSQL();
        String sql = clickHouseFilterToSQL.encodeToString((Filter)filter);
        Assert.assertEquals((Object)expectedSql, (Object)sql);
    }
}

