/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.dggs.clickhouse.ClickHouseJDBCTestSetup;
import org.geotools.jdbc.JDBCDelegatingTestSetup;
import org.geotools.jdbc.JDBCTestSetup;

public class ClickHouseDateTestSetup
extends JDBCDelegatingTestSetup {
    public ClickHouseDateTestSetup() {
        super((JDBCTestSetup)new ClickHouseJDBCTestSetup());
    }

    protected void setUpData() throws Exception {
        try {
            this.dropDateTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createDateTable();
    }

    protected void createDateTable() throws Exception {
        this.run("CREATE TABLE dates (d DATE, dt DateTime)ENGINE = MergeTree() ORDER BY \"d\" PARTITION by \"d\"");
        TimeZone tz = TimeZone.getDefault();
        String tzId = tz.getID();
        this.run("INSERT INTO dates VALUES (toDate('2009-06-28'), parseDateTimeBestEffort('2009-06-28 15:12:41', '" + tzId + "'))");
        this.run("INSERT INTO dates VALUES (toDate('2009-01-15'), parseDateTimeBestEffort('2009-01-15 13:10:12', '" + tzId + "'))");
        this.run("INSERT INTO dates VALUES (toDate('2009-09-29'), parseDateTimeBestEffort('2009-09-29 17:54:23', '" + tzId + "'))");
    }

    protected void dropDateTable() throws Exception {
        this.runSafe("DROP TABLE dates");
    }

    protected void initializeDataSource(BasicDataSource ds, Properties db) {
        super.initializeDataSource(ds, db);
        ds.addConnectionProperty("typeMappings", "date=java.sql.Date");
    }
}

