/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import com.clickhouse.data.value.UnsignedInteger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickHouseOnlineTestCase;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.h3.H3DGGSFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.jdbc.JDBCDataStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.locationtech.jts.geom.Polygon;

public class ClickHouseH3OnlineTest
extends ClickHouseOnlineTestCase {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Override
    protected String getDGGSId() {
        return new H3DGGSFactory().getId();
    }

    @Override
    protected void setupTestData(ClickHouseDGGSDataStore dataStore) throws Exception {
        try (Connection cx = ((JDBCDataStore)dataStore.getDelegate()).getConnection(Transaction.AUTO_COMMIT);
             Statement st = cx.createStatement();){
            st.execute("DROP TABLE IF EXISTS zoneAttributes");
            st.execute("CREATE TABLE zoneAttributes (\n    zoneId String,\n    ts UInt32,\n    value UInt32,\n    resolution UInt8\n) ENGINE = MergeTree()\nORDER BY (zoneId, ts);");
            st.execute("INSERT INTO zoneAttributes VALUES\n('8009fffffffffff', 1, 100, 0),\n('8009fffffffffff', 2, 50, 0),\n('8009fffffffffff', 3, 150, 0),\n('8011fffffffffff', 1, 75, 0),\n('8011fffffffffff', 2, 25, 0),\n('8011fffffffffff', 3, 0, 0);");
        }
    }

    public void testTypeNames() throws IOException {
        List<String> names = Arrays.asList(this.dataStore.getTypeNames());
        MatcherAssert.assertThat(names, (Matcher)Matchers.hasItem((Object)"zoneAttributes"));
    }

    public void testDataStoreSchema() throws IOException {
        SimpleFeatureType schema = this.dataStore.getSchema("zoneAttributes");
        this.assertZoneAttributesSchema(schema);
    }

    public void testFeatureSourceSchema() throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.dataStore.getFeatureSource("zoneAttributes").getSchema();
        this.assertZoneAttributesSchema(schema);
    }

    public void testFeatureCollectionSchema() throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.dataStore.getFeatureSource("zoneAttributes").getFeatures().getSchema();
        this.assertZoneAttributesSchema(schema);
    }

    private void assertZoneAttributesSchema(SimpleFeatureType schema) {
        ClickHouseH3OnlineTest.assertEquals((int)5, (int)schema.getAttributeDescriptors().size());
        this.assertDescriptor(schema, "zoneId", String.class);
        this.assertDescriptor(schema, "resolution", Short.class);
        this.assertDescriptor(schema, "ts", Long.class);
        this.assertDescriptor(schema, "value", Long.class);
        this.assertDescriptor(schema, "geometry", Polygon.class);
    }

    private void assertDescriptor(SimpleFeatureType schema, String name, Class<?> binding) {
        AttributeDescriptor ad = schema.getDescriptor(name);
        ClickHouseH3OnlineTest.assertNotNull((String)(name + " not found"), (Object)ad);
        ClickHouseH3OnlineTest.assertEquals(binding, (Object)ad.getType().getBinding());
    }

    public void testCountAll() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("zoneAttributes");
        ClickHouseH3OnlineTest.assertEquals((int)6, (int)fs.getCount(Query.ALL));
    }

    public void testDelegateGroupBy() throws Exception {
        final AtomicInteger visitCount = new AtomicInteger(0);
        final AtomicBoolean setValueCalled = new AtomicBoolean(false);
        GroupByVisitor visitor = new GroupByVisitor(Aggregate.MAX, (Expression)FF.property("value"), List.of(FF.property("geometry")), null){

            public void visit(Feature feature) {
                super.visit(feature);
                visitCount.incrementAndGet();
            }

            public void setValue(List<GroupByVisitor.GroupByRawResult> value) {
                super.setValue(value);
                setValueCalled.set(true);
            }
        };
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("zoneAttributes");
        fs.getFeatures().accepts((FeatureVisitor)visitor, null);
        ClickHouseH3OnlineTest.assertEquals((int)0, (int)visitCount.get());
        ClickHouseH3OnlineTest.assertTrue((boolean)setValueCalled.get());
        DGGSInstance ddgs = this.dataStore.getDggs();
        Polygon p1 = ddgs.getZone("8009fffffffffff").getBoundary();
        Polygon p2 = ddgs.getZone("8011fffffffffff").getBoundary();
        Map results = visitor.getResult().toMap();
        ClickHouseH3OnlineTest.assertEquals((int)2, (int)results.size());
        ClickHouseH3OnlineTest.assertEquals((Object)UnsignedInteger.valueOf((int)150), results.get(List.of(p1)));
        ClickHouseH3OnlineTest.assertEquals((Object)UnsignedInteger.valueOf((int)75), results.get(List.of(p2)));
    }
}

