/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickHouseOnlineTestCase;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.rhealpix.RHealPixDGGSFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Polygon;

public class ClickHouseRHealPixOnlineTest
extends ClickHouseOnlineTestCase {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Override
    protected String getDGGSId() {
        return new RHealPixDGGSFactory().getId();
    }

    @Override
    protected void setupTestData(ClickHouseDGGSDataStore dataStore) throws Exception {
        try (Connection cx = ((JDBCDataStore)dataStore.getDelegate()).getConnection(Transaction.AUTO_COMMIT);
             Statement st = cx.createStatement();
             PreparedStatement ps = cx.prepareStatement("INSERT INTO \"rpix\" VALUES (?, ?, ?)");){
            st.execute("DROP TABLE IF EXISTS rpix");
            st.execute("DROP TABLE IF EXISTS not_dggs");
            st.execute("CREATE TABLE \"rpix\"(\"zoneId\" String, \"resolution\" Int32, \"value\" Float64) ENGINE = MergeTree() PARTITION BY substring(zoneId, 1, 1)\nORDER BY (resolution, zoneId)");
            String[] zones = new String[]{"N", "O", "P", "Q", "R", "S"};
            for (int i = 0; i < zones.length; ++i) {
                String zoneId = zones[i];
                ps.setString(1, zoneId);
                ps.setInt(2, 0);
                ps.setDouble(3, i);
                ps.addBatch();
                for (int j = 0; j < 9; ++j) {
                    String subZone = zoneId + j;
                    int subZoneValue = i * 10 + j;
                    ps.setString(1, subZone);
                    ps.setInt(2, 1);
                    ps.setDouble(3, subZoneValue);
                    ps.addBatch();
                    for (int k = 0; k < 2; ++k) {
                        String subSubZone = subZone + k;
                        int subSubZoneValue = subZoneValue * 10 + k;
                        ps.setString(1, subSubZone);
                        ps.setInt(2, 2);
                        ps.setDouble(3, subSubZoneValue);
                        ps.addBatch();
                    }
                }
            }
            ps.executeBatch();
            st.execute("CREATE TABLE \"not_dggs\"(\"fid\" String, \"test\" Int32) ENGINE = MergeTree() PARTITION BY fid\nORDER BY fid");
        }
    }

    public void testTypeNames() throws IOException {
        String[] typeNames = this.dataStore.getTypeNames();
        ClickHouseRHealPixOnlineTest.assertEquals((int)1, (int)typeNames.length);
        ClickHouseRHealPixOnlineTest.assertEquals((String)"rpix", (String)typeNames[0]);
    }

    public void testDataStoreSchema() throws IOException {
        SimpleFeatureType schema = this.dataStore.getSchema("rpix");
        this.assertRPixSchema(schema);
    }

    public void testFeatureSourceSchema() throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.dataStore.getFeatureSource("rpix").getSchema();
        this.assertRPixSchema(schema);
    }

    public void testFeatureCollectionSchema() throws IOException {
        SimpleFeatureType schema = (SimpleFeatureType)this.dataStore.getFeatureSource("rpix").getFeatures().getSchema();
        this.assertRPixSchema(schema);
    }

    private void assertRPixSchema(SimpleFeatureType schema) {
        ClickHouseRHealPixOnlineTest.assertEquals((int)4, (int)schema.getAttributeDescriptors().size());
        this.assertDescriptor(schema, "zoneId", String.class);
        this.assertDescriptor(schema, "resolution", Integer.class);
        this.assertDescriptor(schema, "value", Double.class);
        this.assertDescriptor(schema, "geometry", Polygon.class);
    }

    private void assertDescriptor(SimpleFeatureType schema, String name, Class<?> binding) {
        AttributeDescriptor ad = schema.getDescriptor(name);
        ClickHouseRHealPixOnlineTest.assertNotNull((String)(name + " not found"), (Object)ad);
        ClickHouseRHealPixOnlineTest.assertEquals(binding, (Object)ad.getType().getBinding());
    }

    public void testCountAll() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        ClickHouseRHealPixOnlineTest.assertEquals((int)168, (int)fs.getCount(Query.ALL));
    }

    public void testCountLikeZone() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        PropertyIsLike like = FF.like((Expression)FF.property("zoneId"), "R%");
        ClickHouseRHealPixOnlineTest.assertEquals((int)28, (int)fs.getCount(new Query(null, (Filter)like)));
    }

    public void testCountFilterResolution() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        PropertyIsEqualTo eq = FF.equals((Expression)FF.property("resolution"), (Expression)FF.literal(2));
        ClickHouseRHealPixOnlineTest.assertEquals((int)108, (int)fs.getCount(new Query(null, (Filter)eq)));
    }

    public void testCountSouthPolar() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        BBOX bbox = FF.bbox((Expression)FF.property("geometry"), (BoundingBox)new ReferencedEnvelope(-180.0, 180.0, -90.0, -60.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        ClickHouseRHealPixOnlineTest.assertEquals((int)-1, (int)fs.getCount(new Query(null, (Filter)bbox)));
    }

    public void testCountSouthPolarResolutionOne() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        BBOX bbox = FF.bbox((Expression)FF.property("geometry"), (BoundingBox)new ReferencedEnvelope(-180.0, 180.0, -90.0, -60.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        Query q = new Query(null, (Filter)bbox);
        this.addResolutionHint(q, 1);
        ClickHouseRHealPixOnlineTest.assertEquals((int)9, (int)fs.getCount(q));
    }

    private void addResolutionHint(Query q, int resolution) {
        Map<String, Integer> vp = Collections.singletonMap("res", resolution);
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, vp);
    }

    public void testGetAllFeatures() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        Query q = new Query();
        q.setSortBy(new SortBy[]{FF.sort("zoneId", SortOrder.ASCENDING)});
        q.setMaxFeatures(2);
        List features = DataUtilities.list((FeatureCollection)fs.getFeatures(q));
        ClickHouseRHealPixOnlineTest.assertEquals((int)2, (int)features.size());
        SimpleFeature f0 = (SimpleFeature)features.get(0);
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"N", (Object)f0.getAttribute("zoneId"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)0, (Object)f0.getAttribute("resolution"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)fs.getDGGS().getZone("N").getBoundary(), (Object)f0.getAttribute("geometry"));
        SimpleFeature f1 = (SimpleFeature)features.get(1);
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"N0", (Object)f1.getAttribute("zoneId"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)1, (Object)f1.getAttribute("resolution"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)fs.getDGGS().getZone("N0").getBoundary(), (Object)f1.getAttribute("geometry"));
    }

    public void testGetFeaturesByBoundingBox() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        Query q = new Query();
        q.setFilter((Filter)FF.bbox((Expression)FF.property(""), (BoundingBox)new ReferencedEnvelope(-37.0, 47.0, -39.0, 40.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84)));
        this.addResolutionHint(q, 2);
        q.setSortBy(new SortBy[]{FF.sort("zoneId", SortOrder.ASCENDING)});
        q.setMaxFeatures(2);
        List features = DataUtilities.list((FeatureCollection)fs.getFeatures(q));
        ClickHouseRHealPixOnlineTest.assertEquals((int)2, (int)features.size());
        SimpleFeature f0 = (SimpleFeature)features.get(0);
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"R00", (Object)f0.getAttribute("zoneId"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)2, (Object)f0.getAttribute("resolution"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)fs.getDGGS().getZone("R00").getBoundary(), (Object)f0.getAttribute("geometry"));
        SimpleFeature f1 = (SimpleFeature)features.get(1);
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"R01", (Object)f1.getAttribute("zoneId"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)2, (Object)f1.getAttribute("resolution"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)fs.getDGGS().getZone("R01").getBoundary(), (Object)f1.getAttribute("geometry"));
    }

    public void testGetAllFeaturesDefaultGeometry() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        Query q = new Query();
        q.setSortBy(new SortBy[]{FF.sort("zoneId", SortOrder.ASCENDING)});
        q.setPropertyNames(new String[]{"geometry"});
        q.setMaxFeatures(1);
        List features = DataUtilities.list((FeatureCollection)fs.getFeatures(q));
        ClickHouseRHealPixOnlineTest.assertEquals((int)1, (int)features.size());
        SimpleFeature f0 = (SimpleFeature)features.get(0);
        ClickHouseRHealPixOnlineTest.assertEquals((Object)fs.getDGGS().getZone("N").getBoundary(), (Object)f0.getAttribute("geometry"));
    }

    public void testGetAllFeaturesPaging() throws Exception {
        DGGSFeatureSource fs = this.dataStore.getFeatureSource("rpix");
        Query q = new Query();
        q.setFilter((Filter)FF.equals((Expression)FF.property("resolution"), (Expression)FF.literal(0)));
        q.setStartIndex(Integer.valueOf(2));
        q.setMaxFeatures(2);
        List features = DataUtilities.list((FeatureCollection)fs.getFeatures(q));
        ClickHouseRHealPixOnlineTest.assertEquals((int)2, (int)features.size());
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"P", (Object)((SimpleFeature)features.get(0)).getAttribute("zoneId"));
        ClickHouseRHealPixOnlineTest.assertEquals((Object)"Q", (Object)((SimpleFeature)features.get(1)).getAttribute("zoneId"));
    }
}

