/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.clickhouse.ClickHouseDGGSDataStore;
import org.geotools.dggs.clickhouse.ClickhouseAggregatorCollection;
import org.geotools.dggs.clickhouse.DGGSFeatureCollection;
import org.geotools.dggs.clickhouse.DGGSQuerySplitter;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;

public class ClickHouseDGGSFeatureSource
implements DGGSFeatureSource {
    private final ClickHouseDGGSDataStore dataStore;
    private final SimpleFeatureType schema;
    private final SimpleFeatureSource delegate;
    private final DGGSQuerySplitter splitter;

    public ClickHouseDGGSFeatureSource(ClickHouseDGGSDataStore dataStore, SimpleFeatureSource delegate, SimpleFeatureType schema) {
        this.delegate = delegate;
        this.dataStore = dataStore;
        this.schema = schema;
        this.splitter = new DGGSQuerySplitter(dataStore.getDggs(), dataStore.getResolutions(), schema);
    }

    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return this.dataStore;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.delegate.getSupportedHints();
    }

    public DGGSInstance getDGGS() {
        return this.dataStore.getDggs();
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(ClickHouseDGGSFeatureSource.this.getSchema().getTypeName());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return ClickHouseDGGSFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return ClickHouseDGGSFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return ClickHouseDGGSFeatureSource.this.getSchema().getTypeName();
            }

            public URI getSchema() {
                Name name = ClickHouseDGGSFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = ClickHouseDGGSFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    public void addFeatureListener(FeatureListener listener) {
    }

    public void removeFeatureListener(FeatureListener listener) {
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return null;
    }

    public int getCount(Query query) throws IOException {
        DGGSQuerySplitter.PrePost split = this.splitter.split(query);
        if (split.post != Filter.INCLUDE) {
            return -1;
        }
        return this.delegate.getCount(split.pre);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.getSchema().getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        DGGSQuerySplitter.PrePost split = this.splitter.split(query);
        Object result = this.delegate.getFeatures(split.pre);
        String[] propertyNames = query.getPropertyNames();
        if (propertyNames == null || Arrays.stream(propertyNames).anyMatch(n -> "geometry".equals(n) || "".equals(n))) {
            SimpleFeatureType outputSchema = this.getSchema();
            if (propertyNames != null) {
                outputSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.getSchema(), (String[])propertyNames);
            }
            result = new DGGSFeatureCollection((SimpleFeatureCollection)result, outputSchema, this.getDGGS());
        }
        if (split.post != Filter.INCLUDE) {
            result = new FilteringSimpleFeatureCollection(result, split.post);
        } else if (this.delegate.getDataStore() instanceof JDBCDataStore) {
            result = new ClickhouseAggregatorCollection((SimpleFeatureCollection)result, (JDBCDataStore)this.delegate.getDataStore(), new Query(split.pre), this.getSchema());
        }
        result = this.reprojectFeatureCollection((SimpleFeatureCollection)result, query);
        return result;
    }

    private SimpleFeatureCollection reprojectFeatureCollection(SimpleFeatureCollection result, Query query) throws IOException {
        CoordinateReferenceSystem sourceCRS = query.getCoordinateSystem();
        CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
        if (sourceCRS != null && !sourceCRS.equals(ClickHouseDGGSDataStore.DEFAULT_CRS)) {
            try {
                result = DataUtilities.simple((FeatureCollection)new ForceCoordinateSystemFeatureResults((FeatureCollection)result, sourceCRS));
            }
            catch (SchemaException e) {
                throw (IOException)new IOException("Error occurred trying to force CRS").initCause(e);
            }
        } else {
            sourceCRS = ClickHouseDGGSDataStore.DEFAULT_CRS;
        }
        if (targetCRS != null) {
            if (sourceCRS == null) {
                throw new IOException("Cannot reproject data, the source CRS is not available");
            }
            if (!sourceCRS.equals(targetCRS)) {
                try {
                    result = new ReprojectingFeatureCollection(result, targetCRS);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Error occurred trying to reproject data").initCause(e);
                }
            }
        }
        return result;
    }
}

