/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class DGGSFeatureCollection
implements SimpleFeatureCollection {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private final SimpleFeatureType schema;
    private final DGGSInstance dggs;
    private final SimpleFeatureCollection delegate;

    public DGGSFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType schema, DGGSInstance dggs) {
        this.delegate = delegate;
        this.schema = schema;
        this.dggs = dggs;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public String getID() {
        return this.delegate.getID();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        GroupByVisitor groupByVisitor;
        if (DGGSFeatureCollection.isGeometryless(visitor, this.getSchema())) {
            this.delegate.accepts(visitor, progress);
        }
        if (visitor instanceof GroupByVisitor && this.delegateGroupBy(progress, groupByVisitor = (GroupByVisitor)visitor)) {
            return;
        }
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    private boolean delegateGroupBy(ProgressListener progress, GroupByVisitor groupByVisitor) throws IOException {
        Expression expression = groupByVisitor.getExpression();
        List groupByAttributes = groupByVisitor.getGroupByAttributes();
        if (!(expression instanceof PropertyName) || "geometry".equals(((PropertyName)expression).getPropertyName()) || !DGGSFeatureCollection.allPropertyNames(groupByAttributes)) {
            return false;
        }
        int geometryIdx = this.getGeometryIndex(groupByAttributes);
        ArrayList<PropertyName> newGroupAttributes = new ArrayList<PropertyName>(groupByAttributes);
        newGroupAttributes.set(geometryIdx, FF.property("zoneId"));
        GroupByVisitor mappedVisitor = new GroupByVisitor(groupByVisitor.getAggregate(), expression, newGroupAttributes, null);
        this.delegate.accepts((FeatureVisitor)mappedVisitor, progress);
        Map unmappedResults = mappedVisitor.getResult().toMap();
        List mappedResults = unmappedResults.entrySet().stream().map(e -> {
            List key = (List)e.getKey();
            Zone zone = this.dggs.getZone((String)key.get(geometryIdx));
            key.set(geometryIdx, zone.getBoundary());
            return new GroupByVisitor.GroupByRawResult(key, e.getValue());
        }).collect(Collectors.toList());
        groupByVisitor.setValue(mappedResults);
        return true;
    }

    private int getGeometryIndex(List<Expression> expressions) {
        for (int i = 0; i < expressions.size(); ++i) {
            Expression e = expressions.get(i);
            if (!(e instanceof PropertyName) || !"geometry".equals(((PropertyName)e).getPropertyName())) continue;
            return i;
        }
        throw new IllegalArgumentException("Group by attributes must contain a geometry attribute, but none found in: " + expressions);
    }

    private static boolean allPropertyNames(List<Expression> groupByAttributes) {
        return groupByAttributes.stream().allMatch(e -> e instanceof PropertyName);
    }

    public static boolean isGeometryless(FeatureVisitor visitor, SimpleFeatureType schema) {
        if (visitor instanceof FeatureAttributeVisitor) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(schema);
            for (Expression e : ((FeatureAttributeVisitor)visitor).getExpressions()) {
                e.accept((ExpressionVisitor)extractor, null);
            }
            for (PropertyName pname : extractor.getPropertyNameSet()) {
                AttributeDescriptor att = (AttributeDescriptor)pname.evaluate((Object)schema);
                if (!(att instanceof GeometryDescriptor)) continue;
                return false;
            }
            return true;
        }
        return visitor instanceof CountVisitor;
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection)this);
    }

    public boolean contains(Object o) {
        try (SimpleFeatureIterator fi = this.features();){
            while (fi.hasNext()) {
                SimpleFeature next = (SimpleFeature)fi.next();
                if (!Objects.equals(o, next)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean containsAll(Collection<?> o) {
        HashSet candidates = new HashSet(o);
        try (SimpleFeatureIterator fi = this.features();){
            while (fi.hasNext()) {
                SimpleFeature next = (SimpleFeature)fi.next();
                candidates.remove(next);
                if (!candidates.isEmpty()) continue;
                break;
            }
        }
        return candidates.isEmpty();
    }

    public boolean isEmpty() {
        try (SimpleFeatureIterator fi = this.features();){
            boolean bl = !fi.hasNext();
            return bl;
        }
    }

    public int size() {
        return this.delegate.size();
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            Object[] grown = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            array = grown;
        }
        try (SimpleFeatureIterator it = this.features();){
            int i;
            for (i = 0; it.hasNext() && i < size; ++i) {
                array[i] = it.next();
            }
            while (i < size) {
                array[i] = null;
                ++i;
            }
            Object[] objectArray = array;
            return objectArray;
        }
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return new FilteringSimpleFeatureCollection(this.delegate, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SortedSimpleFeatureCollection(this.delegate, new SortBy[]{order});
    }

    public SimpleFeatureIterator features() {
        final SimpleFeatureIterator it = this.delegate.features();
        final SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.getSchema());
        return new SimpleFeatureIterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public SimpleFeature next() throws NoSuchElementException {
                return DGGSFeatureCollection.this.wrapFeature((SimpleFeature)it.next(), fb);
            }

            public void close() {
                it.close();
            }
        };
    }

    private SimpleFeature wrapFeature(SimpleFeature next, SimpleFeatureBuilder fb) {
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            String name = ad.getLocalName();
            if ("geometry".equals(name)) {
                Zone zone = this.dggs.getZone((String)next.getAttribute("zoneId"));
                fb.add((Object)zone.getBoundary());
                continue;
            }
            fb.add(next.getAttribute(name));
        }
        return fb.buildFeature(next.getID());
    }
}

