/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2020, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.dggs;

import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;

/** Implemented by functions needing a {@link DGGSInstance} reference to work, and used by {@link DGGSFilterVisitor}. */
public interface DGGSFunction {

    public static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    public void setDGGSInstance(DGGSInstance instance);
}
