/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.io.IOException;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.h3.H3DGGSFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NeighborFunctionTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static DGGSInstance DGGS;

    @BeforeClass
    public static void onSetup() throws IOException {
        DGGS = new H3DGGSFactory().createInstance(null);
    }

    @After
    public void cleanupEnv() {
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testNeighborFunctionCacheable() {
        Function testedZone = FF.function("env", new Expression[]{FF.literal((Object)"test")});
        Function neighbor = FF.function("neighbor", new Expression[]{testedZone, FF.literal((Object)"807ffffffffffff"), FF.literal(1), FF.literal((Object)DGGS)});
        Assert.assertNotNull((Object)neighbor);
        EnvFunction.setLocalValue((String)"test", (Object)"805bfffffffffff");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"809bfffffffffff");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"800bfffffffffff");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"abcd");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
    }

    @Test
    public void testNeighborFunctionNonCacheable() {
        Function testedZone = FF.function("env", new Expression[]{FF.literal((Object)"test")});
        Function referenceZone = FF.function("env", new Expression[]{FF.literal((Object)"testReference")});
        Function neighbor = FF.function("neighbor", new Expression[]{testedZone, referenceZone, FF.literal(1), FF.literal((Object)DGGS)});
        Assert.assertNotNull((Object)neighbor);
        EnvFunction.setLocalValue((String)"testReference", (Object)"807ffffffffffff");
        EnvFunction.setLocalValue((String)"test", (Object)"805bfffffffffff");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"809bfffffffffff");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"800bfffffffffff");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", (Object)"abcd");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
        EnvFunction.setLocalValue((String)"test", null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)neighbor.evaluate(null));
    }
}

