/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.google.common.collect.Iterators;
import com.uber.h3core.H3Core;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Logger;
import jep.JepException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.dggs.DGGSFactory;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class H3DGGSInstanceTest {
    static final Logger LOGGER = Logging.getLogger(H3DGGSInstanceTest.class);
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final GeometryFactory GF = new GeometryFactory();
    private DGGSInstance h3i;
    private H3Core h3;

    @Before
    public void setup() throws IOException {
        Optional<DGGSFactory> factory = DGGSFactoryFinder.getExtensionFactories().filter(d -> "H3".equalsIgnoreCase(d.getId())).findFirst();
        Assert.assertTrue((boolean)factory.isPresent());
        this.h3i = factory.get().createInstance(null);
        this.h3 = H3Core.newInstance();
    }

    @Test
    public void getZone() throws JepException {
        Zone zone = this.h3i.getZone("8029fffffffffff");
        Assert.assertNotNull((Object)zone);
        Assert.assertEquals((long)0L, (long)zone.getResolution());
    }

    @Test
    public void zonesFromEnvelopeWorldResZero() {
        Iterator zonesIterator = this.h3i.zonesFromEnvelope((Envelope)WORLD, 0, false);
        HashSet zones = new HashSet();
        zonesIterator.forEachRemaining(zones::add);
        Assert.assertEquals((long)122L, (long)zones.size());
    }

    @Test
    public void zonesFromEnvelopeAcrossDateline() throws IOException {
        Iterator zonesIterator = this.h3i.zonesFromEnvelope((Envelope)new ReferencedEnvelope(179.0, 181.0, -10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 0, false);
        HashSet zones = new HashSet();
        zonesIterator.forEachRemaining(zones::add);
        Assert.assertEquals((long)2L, (long)zones.size());
    }

    @Test
    public void countZonesFromEnvelopeWorldResZero() {
        ReferencedEnvelope envelope = WORLD;
        this.assertZoneCount(envelope, 0);
    }

    @Test
    public void countZonesFromEnvelopeWorldResOne() {
        ReferencedEnvelope envelope = WORLD;
        this.assertZoneCount(envelope, 1);
    }

    @Test
    public void countZonesFromEnvelopeWorldResTwo() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(-1.0, 1.0, -1.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 2);
    }

    @Test
    public void countZonesCloseToPole() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(102.0, 103.0, 88.9, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 4);
    }

    @Test
    public void countZonesCloseToDateline() {
        ReferencedEnvelope envelope = new ReferencedEnvelope(175.0, 176.0, 81.4, 81.7, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertZoneCount(envelope, 1);
    }

    @Test
    @Ignore
    public void testRandomized() {
        Random random = new Random();
        int LOOPS = 1000;
        int MAX_RESOLUTION = 4;
        for (int i = 0; i < 1000; ++i) {
            double lon1 = random.nextDouble() * 360.0 - 180.0;
            double lon2 = lon1 + random.nextDouble() * (180.0 - lon1);
            double lat1 = random.nextDouble() * 180.0 - 90.0;
            double lat2 = lat1 + random.nextDouble() * (90.0 - lat1);
            ReferencedEnvelope envelope = new ReferencedEnvelope(lon1, lon2, lat1, lat2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            int resolution = (int)(random.nextDouble() * 4.0);
            try {
                this.assertZoneCount(envelope, resolution);
                continue;
            }
            catch (AssertionError e) {
                LOGGER.severe(envelope + " / " + resolution + " -> " + ((Throwable)((Object)e)).getMessage());
            }
        }
    }

    public void assertZoneCount(ReferencedEnvelope envelope, int resolution) {
        long count = this.h3i.countZonesFromEnvelope((Envelope)envelope, resolution);
        int expected = Iterators.size((Iterator)this.h3i.zonesFromEnvelope((Envelope)envelope, resolution, false));
        Assert.assertEquals((long)expected, (long)count);
    }

    @Test
    public void testBoundaryNorthPoleZero() throws ParseException {
        Zone zone = this.h3i.getZone("8001fffffffffff");
        Polygon boundary = zone.getBoundary();
        Assert.assertEquals((double)boundary.getEnvelopeInternal().getMinX(), (double)-180.0, (double)0.0);
        Assert.assertEquals((double)boundary.getEnvelopeInternal().getMaxX(), (double)180.0, (double)0.0);
        Assert.assertEquals((double)boundary.getEnvelopeInternal().getMaxY(), (double)90.0, (double)0.0);
        Polygon expected = (Polygon)new WKTReader().read("POLYGON ((-180 86.19672397564815, -34.75841798028461 81.27137179020497, 0.3256103519432604 73.31022368544396, 31.831280499087416 68.92995788193984, 31.831280499087416 68.92995788193984, 62.345344956509784 69.39359648991828, 94.14309010184775 76.163042830191, 145.55819769133683 87.3646953231962, 180 86.19672397564815, 180 90, -180 90, -180 86.19672397564815))");
        Assert.assertTrue((boolean)expected.equalsExact((Geometry)boundary, 1.0E-6));
    }

    @Test
    public void testNeighborsNorthPole() {
        Iterator iterator = this.h3i.neighbors("8001fffffffffff", 1);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"8007fffffffffff", "8009fffffffffff", "800bfffffffffff", "8011fffffffffff", "8003fffffffffff", "8005fffffffffff"}));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"8001fffffffffff"})));
        Assert.assertEquals((long)6L, (long)neighbors.size());
    }

    @Test
    public void testNeighborsDateline() {
        Iterator iterator = this.h3i.neighbors("807ffffffffffff", 1);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"805bfffffffffff", "8077fffffffffff", "809bfffffffffff", "8071fffffffffff", "809ffffffffffff"}));
        MatcherAssert.assertThat(neighbors, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"807ffffffffffff"})));
        Assert.assertEquals((long)5L, (long)neighbors.size());
    }

    @Test
    public void testNeighborsAll() {
        Iterator iterator = this.h3i.neighbors("8075fffffffffff", 10);
        ArrayList neighbors = new ArrayList();
        iterator.forEachRemaining(z -> neighbors.add(z.getId()));
        Iterator zonesIterator = this.h3i.zonesFromEnvelope((Envelope)WORLD, 0, false);
        HashSet expected = new HashSet();
        zonesIterator.forEachRemaining(z -> expected.add(z.getId()));
        expected.remove("8075fffffffffff");
        Assert.assertEquals((long)expected.size(), (long)neighbors.size());
        Assert.assertTrue((boolean)expected.containsAll(neighbors));
    }

    @Test
    public void testChildren() throws Exception {
        String parent = "807ffffffffffff";
        for (int r = 1; r < 4; ++r) {
            HashSet actual = new HashSet();
            this.h3i.children(parent, r).forEachRemaining(z -> actual.add(z.getId()));
            HashSet expected = new HashSet(this.h3.h3ToChildren(parent, r));
            Assert.assertEquals(expected, actual);
        }
    }

    @Test
    public void testMapPoint() throws Exception {
        Point northPole = GF.createPoint(new Coordinate(0.0, 90.0));
        String[] expectedIds = new String[]{"8001fffffffffff", "81033ffffffffff", "820327fffffffff"};
        for (int r = 0; r < expectedIds.length; ++r) {
            Zone zone = this.h3i.point(northPole, r);
            Assert.assertEquals((Object)expectedIds[r], (Object)zone.getId());
        }
    }

    @Test
    public void testMapPolygon() throws Exception {
        Polygon polygon = (Polygon)new WKTReader().read("POLYGON((-1 -1, -1 1, 1 1, 1 -1, -1 -1))");
        HashSet actual = new HashSet();
        this.h3i.polygon(polygon, 3, false).forEachRemaining(z -> actual.add(z.getId()));
        HashSet<String> expected = new HashSet<String>(Arrays.asList("83754afffffffff", "837548fffffffff", "83754efffffffff", "83755dfffffffff"));
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void zonesFromEnvelopeCompact() {
        Iterator zonesIterator = this.h3i.zonesFromEnvelope((Envelope)new ReferencedEnvelope(-14.0, 4.0, -6.0, 11.7, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), 1, true);
        HashSet zones = new HashSet();
        zonesIterator.forEachRemaining(z -> zones.add(z.getId()));
        Assert.assertEquals((long)12L, (long)zones.size());
        MatcherAssert.assertThat(zones, (Matcher)CoreMatchers.hasItem((Object)"8075fffffffffff"));
        MatcherAssert.assertThat(zones, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"8154fffffffffff", "81583ffffffffff", "81827ffffffffff", "817cbffffffffff", "8158bffffffffff", "8159bffffffffff", "8182fffffffffff", "81993ffffffffff", "81997ffffffffff", "817dbffffffffff", "81547ffffffffff"}));
    }
}

