/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.gstore.DGGSGeometryFeatureSource;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.dggs.gstore.DGGSStore;
import org.geotools.feature.NameImpl;

public class DGGSGeometryStore
extends ContentDataStore
implements DGGSStore {
    public static final String ZONE_ID = "zoneId";
    public static final String RESOLUTION = "resolution";
    public static final String GEOMETRY = "geometry";
    DGGSInstance dggs;
    DGGSResolutionCalculator resolutions;

    public DGGSGeometryStore(DGGSInstance dggs) {
        this.dggs = dggs;
        this.resolutions = new DGGSResolutionCalculator(dggs);
    }

    protected List<Name> createTypeNames() throws IOException {
        return Arrays.asList(new NameImpl(this.namespaceURI, this.dggs.getIdentifier()));
    }

    protected DGGSGeometryFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return new DGGSGeometryFeatureSource(entry, this);
    }

    public void dispose() {
        this.dggs.close();
    }

    @Override
    public DGGSFeatureSource getDGGSFeatureSource(String typeName) throws IOException {
        ContentEntry entry = this.ensureEntry((Name)new NameImpl(this.namespaceURI, typeName));
        return new DGGSGeometryFeatureSource(entry, this);
    }
}

