/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.awt.RenderingHints;
import java.util.Map;
import java.util.Optional;
import org.geotools.api.data.Query;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.filter.function.EnvFunction;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.algorithm.MinimumBoundingCircle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class DGGSResolutionCalculator {
    public static final String WMS_SCALE_DENOMINATOR = "WMS_SCALE_DENOMINATOR";
    private static final double DISTANCE_SCALE_FACTOR = 2.8000000000000003E-4;
    public static final String CONFIGURED_OFFSET_KEY = "dggs.resOffset";
    static final Hints.ConfigurationMetadataKey OFFSET_HINTS_KEY = Hints.ConfigurationMetadataKey.get((String)"dggs.resOffset");
    public static final String CONFIGURED_MINRES_KEY = "dggs.minResolution";
    static final Hints.ConfigurationMetadataKey MINRES_HINTS_KEY = Hints.ConfigurationMetadataKey.get((String)"dggs.minResolution");
    public static final String CONFIGURED_MAXRES_KEY = "dggs.maxResolution";
    static final Hints.ConfigurationMetadataKey MAXRES_HINTS_KEY = Hints.ConfigurationMetadataKey.get((String)"dggs.maxResolution");
    double[] levelThresholds;

    public DGGSResolutionCalculator(DGGSInstance dggs) {
        this.levelThresholds = new double[dggs.getResolutions().length];
        for (int i = 0; i < this.levelThresholds.length; ++i) {
            Zone zone = dggs.getZone(0.0, 0.0, i);
            Polygon polygon = zone.getBoundary();
            double radius = new MinimumBoundingCircle((Geometry)polygon).getRadius();
            this.levelThresholds[i] = radius / 100.0;
        }
    }

    public int getTargetResolution(Query query, int defaultResolution) {
        Hints hints = query.getHints();
        Optional<Map> viewParams = Optional.ofNullable(hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS)).filter(Map.class::isInstance).map(Map.class::cast);
        Optional<Integer> requestedResolution = viewParams.map(m -> m.get("res")).map(n -> this.safeConvert(n, Integer.class));
        if (requestedResolution.isPresent()) {
            return this.validateResolution(requestedResolution.get());
        }
        Double sd = this.safeConvert(EnvFunction.getLocalValues().get(WMS_SCALE_DENOMINATOR), Double.class);
        Optional<Double> distance = sd != null ? Optional.of(this.scaleToDistance((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, sd)) : this.getDoubleHint(hints, Hints.GEOMETRY_DISTANCE);
        Optional<Integer> resolutionDelta = viewParams.map(m -> m.get("resOffset")).map(n -> this.safeConvert(n, Integer.class));
        if (!resolutionDelta.isPresent()) {
            resolutionDelta = this.getIntegerHint(hints, OFFSET_HINTS_KEY);
        }
        int resOffset = resolutionDelta.orElse(0);
        int resolution = distance.map(n -> this.getResolutionFromThresholds((double)n) + resOffset).orElse(defaultResolution);
        resolution = Math.max(this.getIntegerHint(hints, MINRES_HINTS_KEY).orElse(-2147483647), resolution);
        resolution = Math.min(this.getIntegerHint(hints, MAXRES_HINTS_KEY).orElse(Integer.MAX_VALUE), resolution);
        return resolution;
    }

    private Optional<Integer> getIntegerHint(Hints hints, Object key) {
        return Optional.ofNullable(hints.get(key)).map(n -> this.safeConvert(n, Integer.class));
    }

    private Optional<Double> getDoubleHint(Hints hints, Object key) {
        return Optional.ofNullable(hints.get(key)).map(n -> this.safeConvert(n, Double.class));
    }

    double scaleToDistance(CoordinateReferenceSystem crs, double scaleDenominator) {
        return scaleDenominator * 2.8000000000000003E-4 / RendererUtilities.toMeters((double)1.0, (CoordinateReferenceSystem)crs);
    }

    private int getResolutionFromThresholds(double distance) {
        if (distance == 0.0) {
            return 0;
        }
        for (int i = 0; i < this.levelThresholds.length; ++i) {
            if (!(this.levelThresholds[i] < distance)) continue;
            return i;
        }
        return this.levelThresholds.length - 1;
    }

    private int validateResolution(int resolution) {
        if (resolution < 0 || resolution >= this.levelThresholds.length) {
            throw new IllegalArgumentException("Requested resolution " + resolution + " is not valid, please provide a value between 0 and " + (this.levelThresholds.length - 1));
        }
        return resolution;
    }

    private <T> T safeConvert(Object n, Class<T> target) {
        return (T)Converters.convert((Object)n, target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true));
    }

    public boolean isValid(int targetResolution) {
        return targetResolution >= 0 && targetResolution < this.levelThresholds.length;
    }

    public NumberRange<Integer> getValidResolutions() {
        return new NumberRange(Integer.class, (Number)0, (Number)(this.levelThresholds.length - 1));
    }
}

