/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import java.util.BitSet;

class H3Index {
    private final long id;

    public H3Index(long id) {
        this.id = id;
    }

    public int getResolution() {
        int shifted = (int)(this.id >>> 52);
        return shifted & 0xF;
    }

    public long lowestIdChild(int targetResolution) {
        int base;
        int resolution = this.getResolution();
        if (resolution > 14) {
            throw new IllegalArgumentException("This H3 cell has no children");
        }
        long childId = this.id & 0x800000000000000L | (long)targetResolution << 52 | this.id & 0xFFFFFFFFFFFFFL;
        BitSet bitSet = this.toBitSet(childId);
        for (int i = base = 19 + resolution * 3; i < 64; ++i) {
            bitSet.set(i, false);
        }
        return this.fromBitSet(bitSet);
    }

    public long highestIdChild(int targetResolution) {
        int resolution = this.getResolution();
        if (resolution > 14) {
            throw new IllegalArgumentException("This H3 cell has no children");
        }
        long childId = this.id & 0x800000000000000L | (long)targetResolution << 52 | this.id & 0xFFFFFFFFFFFFFL;
        return childId;
    }

    public BitSet toBitSet(long value) {
        BitSet bits = new BitSet(64);
        int index = 63;
        while (value != 0L) {
            if (value % 2L != 0L) {
                bits.set(index);
            }
            --index;
            value >>>= 1;
        }
        return bits;
    }

    public long fromBitSet(BitSet bits) {
        long result = 0L;
        for (int i = 63; i >= 0; --i) {
            result += bits.get(i) ? 1L << 63 - i : 0L;
        }
        return result;
    }
}

