/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.dggs.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.dggs.gstore.DGGSGeometryStore;
import org.geotools.dggs.gstore.DGGSGeometryStoreFactory;
import org.geotools.dggs.gstore.DGGSStore;
import org.geotools.dggs.h3.H3DGGSFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class DGGSGeometryStoreTest {
    private static final String NAMESPACE = "http://this.is/my/test/namespace";
    private final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Before
    public void ensureAvailable() {
        Assume.assumeTrue((boolean)new H3DGGSFactory().isAvailable());
    }

    @Test
    public void testH3StoreCreation() throws IOException {
        DataStore store = this.getH3Store();
        MatcherAssert.assertThat((Object)store, (Matcher)CoreMatchers.instanceOf(DGGSStore.class));
        MatcherAssert.assertThat((Object)store, (Matcher)CoreMatchers.instanceOf(DGGSGeometryStore.class));
        Assert.assertEquals((long)1L, (long)store.getTypeNames().length);
        Assert.assertEquals((Object)"H3", (Object)store.getTypeNames()[0]);
        SimpleFeatureType schema = store.getSchema("H3");
        Assert.assertEquals((Object)NAMESPACE, (Object)schema.getName().getNamespaceURI());
        Assert.assertNotNull((Object)schema.getDescriptor("zoneId"));
        Assert.assertNotNull((Object)schema.getDescriptor("resolution"));
        Assert.assertNotNull((Object)schema.getDescriptor("geometry"));
    }

    public DataStore getH3Store() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DGGSGeometryStoreFactory.DGGS_FACTORY_ID.key, "H3");
        params.put(DGGSGeometryStoreFactory.NAMESPACE.key, NAMESPACE);
        DataStore store = DataStoreFinder.getDataStore(params);
        return store;
    }

    @Test
    public void testDistanceHint() throws IOException {
        DataStore store = this.getH3Store();
        SimpleFeatureSource fs = store.getFeatureSource("H3");
        Query q = new Query();
        q.getHints().put((Object)Hints.GEOMETRY_DISTANCE, (Object)1.0);
        SimpleFeature f1deg = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)0, (Object)f1deg.getAttribute("resolution"));
        q.getHints().put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.01);
        SimpleFeature f1km = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)3, (Object)f1km.getAttribute("resolution"));
    }

    @Test
    public void testResolutionHint() throws IOException {
        DataStore store = this.getH3Store();
        SimpleFeatureSource fs = store.getFeatureSource("H3");
        Query q = new Query();
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("res", 13));
        SimpleFeature f13 = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)13, (Object)f13.getAttribute("resolution"));
        try {
            q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("res", -1));
            DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-1"));
        }
        try {
            q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("res", 50));
            DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"50"));
        }
    }

    @Test
    public void testResolutionOffsetHint() throws IOException {
        DataStore store = this.getH3Store();
        SimpleFeatureSource fs = store.getFeatureSource("H3");
        Query q = new Query();
        q.getHints().put((Object)Hints.GEOMETRY_DISTANCE, (Object)1.0E-5);
        SimpleFeature f13 = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)10, (Object)f13.getAttribute("resolution"));
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("resOffset", -3));
        SimpleFeature f13m3 = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)7, (Object)f13m3.getAttribute("resolution"));
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("resOffset", 3));
        SimpleFeature f13p3 = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(q));
        Assert.assertEquals((Object)13, (Object)f13p3.getAttribute("resolution"));
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("resOffset", -100));
        Assert.assertEquals((long)0L, (long)DataUtilities.count((FeatureCollection)fs.getFeatures(q)));
        q.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("resOffset", 100));
        Assert.assertEquals((long)0L, (long)DataUtilities.count((FeatureCollection)fs.getFeatures(q)));
    }

    @Test
    public void testNeighbor() throws IOException, CQLException {
        DataStore store = this.getH3Store();
        SimpleFeatureSource fs = store.getFeatureSource("H3");
        Query q = new Query();
        q.setFilter(ECQL.toFilter((String)"neighbor(zoneId, '807ffffffffffff', 1) = true"));
        SimpleFeatureCollection features = fs.getFeatures(q);
        Assert.assertEquals((long)5L, (long)features.size());
        HashSet identifiers = new HashSet();
        features.accepts(feature -> identifiers.add((String)feature.getProperty("zoneId").getValue()), null);
        MatcherAssert.assertThat(identifiers, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"805bfffffffffff", "8077fffffffffff", "809bfffffffffff", "8071fffffffffff", "809ffffffffffff"}));
    }

    @Test
    public void testAttributeManagement() throws CQLException, IOException {
        Query q = new Query();
        q.setFilter((Filter)this.FF.bbox("", -20.0, -20.0, 20.0, 20.0, "EPSG:4326"));
        q.setSortBy(new SortBy[]{this.FF.sort("shape", SortOrder.DESCENDING), this.FF.sort("zoneId", SortOrder.ASCENDING)});
        q.setPropertyNames(new String[]{"zoneId"});
        DataStore store = this.getH3Store();
        SimpleFeatureCollection features = store.getFeatureSource("H3").getFeatures(q);
        Assert.assertEquals((long)1L, (long)((SimpleFeatureType)features.getSchema()).getAttributeCount());
        ArrayList identifiers = new ArrayList();
        features.accepts(feature -> identifiers.add((String)feature.getProperty("zoneId").getValue()), null);
        List<String> expected = Arrays.asList("8075fffffffffff", "803ffffffffffff", "8055fffffffffff", "8059fffffffffff", "806bfffffffffff", "807dfffffffffff", "8083fffffffffff", "8097fffffffffff", "8099fffffffffff", "80a5fffffffffff", "80adfffffffffff");
        Assert.assertEquals(expected, identifiers);
    }
}

