/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.Parameter;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunction;
import org.geotools.dggs.Zone;
import org.geotools.filter.FunctionImpl;

public abstract class DGGSSetFunctionBase
extends FunctionImpl
implements DGGSSetFunction {
    protected Set<String> zoneIds;
    int dggsParameterIndex = -1;
    private int cacheLimit = Integer.parseInt(System.getProperty("dggs.function.cache.limit", "10000"));
    private int iterationLimit = Integer.parseInt(System.getProperty("dggs.function.iteration.limit", "50000"));
    private Boolean cacheTooBig;

    public DGGSSetFunctionBase(FunctionName functionName) {
        this.functionName = functionName;
        this.lookupDGGSParameterIndex(functionName);
    }

    public void lookupDGGSParameterIndex(FunctionName functionName) {
        List arguments = functionName.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            if (!DGGSInstance.class.isAssignableFrom(((Parameter)arguments.get(i)).getType())) continue;
            this.dggsParameterIndex = i;
        }
        if (this.dggsParameterIndex == -1) {
            throw new IllegalArgumentException("Extending class does not expose a DGGSInstance parameter");
        }
    }

    public void setParameters(List<Expression> params) {
        super.setParameters(params);
        this.zoneIds = null;
        this.cacheTooBig = null;
    }

    @Override
    public void setDGGSInstance(DGGSInstance dggs) {
        Literal dggsLiteral = FF.literal((Object)dggs);
        List parameters = this.getParameters();
        if (parameters.size() == this.dggsParameterIndex) {
            parameters.add(dggsLiteral);
        } else {
            parameters.set(this.dggsParameterIndex, dggsLiteral);
        }
        super.setParameters(parameters);
    }

    @Override
    public boolean isStable() {
        return this.getParameters().stream().skip(1L).allMatch(p -> p instanceof Literal);
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public void setIterateLimit(int iterationLimit) {
        this.iterationLimit = iterationLimit;
    }

    protected boolean matches(String zoneId, Supplier<Iterator<Zone>> zonesSupplier) {
        int i;
        if (this.zoneIds != null) {
            return this.zoneIds.contains(zoneId);
        }
        Iterator<Zone> zones = zonesSupplier.get();
        if (this.isStable() && this.cacheTooBig == null) {
            HashSet<String> result = new HashSet<String>();
            if (this.cacheLimit <= 0) {
                zones.forEachRemaining(z -> result.add(z.getId()));
                this.zoneIds = result;
            } else {
                int i2;
                for (i2 = 0; zones.hasNext() && i2 < this.cacheLimit; ++i2) {
                    result.add(zones.next().getId());
                }
                if (i2 >= this.cacheLimit) {
                    this.cacheTooBig = true;
                } else {
                    this.zoneIds = result;
                }
            }
            if (this.zoneIds != null) {
                return this.zoneIds.contains(zoneId);
            }
        }
        for (i = 0; zones.hasNext() && i < this.iterationLimit; ++i) {
            if (!zones.next().getId().equals(zoneId)) continue;
            return true;
        }
        if (i >= this.iterationLimit) {
            throw new IllegalStateException("The iteration loaded up too many zones, above the configured limit of " + this.iterationLimit);
        }
        return false;
    }
}

