/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.dggs.IterableCalcResult;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;

public class GroupedMatrixAggregate
implements FeatureCalc,
FeatureAttributeVisitor {
    private final List<Aggregate> aggregates;
    private final List<Expression> variables;
    private final List<Expression> groupBy;
    private final Map<List<Object>, List<FeatureCalc>> calculators = new LinkedHashMap<List<Object>, List<FeatureCalc>>();
    private CalcResult result;

    public GroupedMatrixAggregate(List<Expression> variables, List<Aggregate> aggregates, List<Expression> groupBy) {
        this.variables = variables;
        this.aggregates = aggregates;
        this.groupBy = groupBy;
    }

    public void setResults(Map<List<Object>, List<Object>> results) {
        LinkedHashMap<List<Object>, List<CalcResult>> wrapped = new LinkedHashMap<List<Object>, List<CalcResult>>();
        results.entrySet().stream().forEach(e -> wrapped.put((List)e.getKey(), this.toCalcResults((List)e.getValue())));
        this.result = new MemoryResult(wrapped);
    }

    public void setResults(CalcResult result) {
        this.result = result;
    }

    private List<CalcResult> toCalcResults(List<Object> results) {
        int expectedSize = this.aggregates.size() * this.variables.size();
        if (results.size() != expectedSize) {
            throw new IllegalArgumentException("Invalid results, size does not match expected: " + expectedSize);
        }
        ArrayList<CalcResult> calcResults = new ArrayList<CalcResult>();
        Iterator<Object> iterator = results.iterator();
        for (Expression variable : this.variables) {
            for (Aggregate aggregate : this.aggregates) {
                calcResults.add(aggregate.wrap(variable, iterator.next()));
            }
        }
        return calcResults;
    }

    public List<FeatureCalc> getCalculators() {
        ArrayList<FeatureCalc> calculators = new ArrayList<FeatureCalc>();
        for (Expression variable : this.variables) {
            for (Aggregate aggregate : this.aggregates) {
                calculators.add(aggregate.create(variable));
            }
        }
        return calculators;
    }

    public CalcResult getResult() {
        if (this.result instanceof IterableResult) {
            return this.result;
        }
        LinkedHashMap<List<Object>, List<CalcResult>> wrapped = new LinkedHashMap<List<Object>, List<CalcResult>>();
        this.calculators.entrySet().stream().forEach(e -> wrapped.put((List)e.getKey(), this.getResult((List)e.getValue())));
        MemoryResult computed = new MemoryResult(wrapped);
        if (this.result == null) {
            return computed;
        }
        return computed.merge(this.result);
    }

    private List<CalcResult> getResult(List<FeatureCalc> calculators) {
        return calculators.stream().map(c -> c.getResult()).collect(Collectors.toList());
    }

    public void visit(Feature feature) {
        List<Object> groupBy = this.evaluateGroupBy(feature);
        List groupCalculators = this.calculators.computeIfAbsent(groupBy, k -> this.getCalculators());
        for (FeatureCalc calc : groupCalculators) {
            calc.visit(feature);
        }
    }

    private List<Object> evaluateGroupBy(Feature feature) {
        return this.groupBy.stream().map(e -> e.evaluate((Object)feature)).collect(Collectors.toList());
    }

    public List<Expression> getExpressions() {
        return Collections.unmodifiableList(this.variables);
    }

    public List<Expression> getGroupBy() {
        return Collections.unmodifiableList(this.groupBy);
    }

    static class MemoryResult
    extends AbstractCalcResult {
        Map<List<Object>, List<CalcResult>> results;

        public MemoryResult(Map<List<Object>, List<CalcResult>> results) {
            this.results = results;
        }

        public Object getValue() {
            LinkedHashMap value = new LinkedHashMap();
            this.results.forEach((k, v) -> value.put(k, this.calcToValue((List<CalcResult>)v)));
            return value;
        }

        private List<Object> calcToValue(List<CalcResult> calcResults) {
            return calcResults.stream().map(cr -> cr.getValue()).collect(Collectors.toList());
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!(resultsToAdd instanceof MemoryResult)) {
                throw new IllegalArgumentException("Cannot merge this result: " + resultsToAdd);
            }
            MemoryResult other = (MemoryResult)resultsToAdd;
            LinkedHashMap<List<Object>, List<CalcResult>> mergedMap = new LinkedHashMap<List<Object>, List<CalcResult>>();
            this.results.entrySet().forEach(e -> {
                List thisResults = (List)e.getValue();
                List<CalcResult> otherResults = other.results.get(e.getKey());
                mergedMap.put((List)e.getKey(), this.mergeResults(thisResults, otherResults));
            });
            other.results.entrySet().stream().filter(e -> this.results.get(e.getKey()) == null).forEach(e -> mergedMap.put((List)e.getKey(), (List)e.getValue()));
            return new MemoryResult(mergedMap);
        }

        private List<CalcResult> mergeResults(List<CalcResult> thisResults, List<CalcResult> otherResults) {
            if (otherResults == null) {
                return thisResults;
            }
            if (otherResults.size() != thisResults.size()) {
                throw new IllegalArgumentException("Size of the two calc results do not match, should be " + this.results.size());
            }
            ArrayList<CalcResult> merged = new ArrayList<CalcResult>();
            for (int i = 0; i < thisResults.size(); ++i) {
                merged.add(thisResults.get(i).merge(otherResults.get(i)));
            }
            return merged;
        }
    }

    public static class IterableResult
    extends AbstractCalcResult
    implements IterableCalcResult<GroupByResult> {
        Supplier<CloseableIterator<GroupByResult>> supplier;

        public IterableResult(Supplier<CloseableIterator<GroupByResult>> supplier) {
            this.supplier = supplier;
        }

        public Object getValue() {
            LinkedHashMap<List<Object>, List<Object>> value = new LinkedHashMap<List<Object>, List<Object>>();
            try (CloseableIterator<GroupByResult> it = this.supplier.get();){
                while (it.hasNext()) {
                    GroupByResult result = (GroupByResult)it.next();
                    value.put(result.getKey(), result.getValues());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return value;
        }

        @Override
        public CloseableIterator<GroupByResult> getIterator() {
            return this.supplier.get();
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            throw new UnsupportedOperationException("Merge was not implemented for this result");
        }
    }

    public static class GroupByResult {
        List<Object> key;
        List<Object> values;

        public GroupByResult(List<Object> key, List<Object> values) {
            this.key = key;
            this.values = values;
        }

        public List<Object> getKey() {
            return this.key;
        }

        public void setKey(List<Object> key) {
            this.key = key;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void setValues(List<Object> values) {
            this.values = values;
        }
    }
}

