/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Literal;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunctionBase;
import org.geotools.dggs.Zone;
import org.locationtech.jts.geom.Polygon;

public class PolygonFunction
extends DGGSSetFunctionBase {
    Set<String> zoneIds;
    public static FunctionName NAME = PolygonFunction.functionName((String)"dggsPolygon", (String)"result:Boolean", (String[])new String[]{"zoneId:String", "polygon:org.locationtech.jts.geom.Polygon", "resolution:Integer", "compact:Boolean", "dggs:org.geotools.dggs.DGGSInstance"});

    public PolygonFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String testedZoneId = (String)this.getParameterValue(object, 0);
        if (testedZoneId == null) {
            return false;
        }
        return this.matches(testedZoneId, () -> {
            Polygon polygon = (Polygon)this.getParameterValue(object, 1);
            Integer resolution = (Integer)this.getParameterValue(object, 2);
            Boolean compact = Optional.ofNullable((Boolean)this.getParameterValue(null, 3)).orElse(false);
            DGGSInstance dggs = (DGGSInstance)this.getParameterValue(object, 4);
            if (polygon == null || resolution == null || dggs == null) {
                return Collections.emptyIterator();
            }
            if (dggs.getZone(testedZoneId).getResolution() != resolution.intValue()) {
                return Collections.emptyIterator();
            }
            return dggs.polygon(polygon, resolution, compact);
        });
    }

    @Override
    public void setDGGSInstance(DGGSInstance dggs) {
        Literal dggsLiteral = FF.literal((Object)dggs);
        List parameters = this.getParameters();
        if (parameters.size() == 4) {
            parameters.add(dggsLiteral);
        } else {
            parameters.set(4, dggsLiteral);
        }
        this.setParameters(parameters);
    }

    @Override
    public Iterator<Zone> getMatchedZones() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        Polygon polygon = (Polygon)this.getParameterValue(null, 1);
        Integer resolution = (Integer)this.getParameterValue(null, 2);
        Boolean compact = Optional.ofNullable((Boolean)this.getParameterValue(null, 3)).orElse(false);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 4);
        return dggs.polygon(polygon, resolution, compact);
    }

    @Override
    public long countMatched() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        Polygon polygon = (Polygon)this.getParameterValue(null, 1);
        Integer resolution = (Integer)this.getParameterValue(null, 2);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 4);
        return dggs.countPolygon(polygon, resolution);
    }
}

