/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.uber.h3core.util.GeoCoord;
import java.util.List;
import java.util.Objects;
import org.geotools.dggs.Zone;
import org.geotools.dggs.ZoneWrapper;
import org.geotools.dggs.h3.H3DGGSInstance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class H3Zone
implements Zone {
    long id;
    H3DGGSInstance dggs;

    public H3Zone(H3DGGSInstance dggs, long zoneId) {
        this.id = zoneId;
        this.dggs = dggs;
    }

    @Override
    public String getId() {
        return this.dggs.h3.h3ToString(this.id);
    }

    @Override
    public int getResolution() {
        return this.dggs.h3.h3GetResolution(this.id);
    }

    @Override
    public Point getCenter() {
        GeoCoord gc = this.dggs.h3.h3ToGeo(this.id);
        return this.dggs.gf.createPoint(new Coordinate(gc.lng, gc.lat));
    }

    @Override
    public Polygon getBoundary() {
        CoordinateSequence cs = this.getCoordinateSequence();
        cs = this.dggs.northPoleZones.contains(this.id) ? ZoneWrapper.includePole(this.dggs.gf, cs, true) : (this.dggs.southPoleZones.contains(this.id) ? ZoneWrapper.includePole(this.dggs.gf, cs, false) : ZoneWrapper.wrap(cs));
        LinearRing ring = this.dggs.gf.createLinearRing(cs);
        return this.dggs.gf.createPolygon(ring);
    }

    private CoordinateSequence getCoordinateSequence() {
        List coords = this.dggs.h3.h3ToGeoBoundary(this.id);
        CoordinateSequenceFactory csf = this.dggs.gf.getCoordinateSequenceFactory();
        int size = coords.size();
        CoordinateSequence cs = csf.create(size + 1, 2);
        for (int i = 0; i < size; ++i) {
            GeoCoord coord = (GeoCoord)coords.get(i);
            cs.setOrdinate(i, 0, coord.lng);
            cs.setOrdinate(i, 1, coord.lat);
        }
        GeoCoord first = (GeoCoord)coords.get(0);
        cs.setOrdinate(size, 0, first.lng);
        cs.setOrdinate(size, 1, first.lat);
        return cs;
    }

    public String toString() {
        return "H3Zone{" + this.getId() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H3Zone h3Zone = (H3Zone)o;
        return this.id == h3Zone.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean overlapsDateline() {
        CoordinateSequence cs = this.getCoordinateSequence();
        return ZoneWrapper.isDatelineCrossing(cs) != ZoneWrapper.DatelineLocation.NotCrossing;
    }

    @Override
    public Object getExtraProperty(String name) {
        if ("shape".equals(name)) {
            boolean pentagon = this.dggs.h3.h3IsPentagon(this.id);
            return pentagon ? "pentagon" : "hexagon";
        }
        throw new IllegalArgumentException("Invalid extra property value " + name);
    }
}

