/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.io.IOException;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.dggs.DGGSFilterVisitor;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.h3.H3DGGSFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DGGSFilterVisitorTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static DGGSInstance DGGS;

    @BeforeClass
    public static void onSetup() throws IOException {
        DGGS = new H3DGGSFactory().createInstance(null);
    }

    @Test
    public void testNonDGGSFunction() {
        Function random = FF.function("random", new Expression[0]);
        Function clone = (Function)random.accept((ExpressionVisitor)new DGGSFilterVisitor(DGGS), null);
        Assert.assertEquals((Object)clone, (Object)random);
    }

    @Test
    public void testNeighbor() {
        Function neighbor = FF.function("neighbor", new Expression[]{FF.literal((Object)"805bfffffffffff"), FF.literal((Object)"807ffffffffffff"), FF.literal(1)});
        Assert.assertNotNull((Object)neighbor);
        Function clone = (Function)neighbor.accept((ExpressionVisitor)new DGGSFilterVisitor(DGGS), null);
        Assert.assertNotEquals((Object)clone, (Object)neighbor);
        Assert.assertEquals((Object)DGGS, (Object)((Expression)clone.getParameters().get(3)).evaluate(null));
    }
}

