/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.geometry.Bounds;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunction;
import org.geotools.dggs.Zone;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class DGGSFilterTransformer
extends DuplicatingFilterVisitor {
    public static final int RESOLUTION_NOT_SPECIFIED = -1;
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    DGGSInstance dggs;
    int resolution;

    public static Filter adapt(Filter filter, DGGSInstance dggs, DGGSResolutionCalculator resolutions, int resolution) {
        DGGSFilterTransformer adapter = new DGGSFilterTransformer(dggs, resolutions, resolution);
        return (Filter)filter.accept((FilterVisitor)adapter, null);
    }

    public DGGSFilterTransformer(DGGSInstance dggs, DGGSResolutionCalculator resolutions, int resolution) {
        this.dggs = dggs;
        this.resolution = resolution;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        DGGSSetFunction function;
        if (filter.getExpression1() instanceof DGGSSetFunction && filter.getExpression2() instanceof Literal && Boolean.TRUE.equals(filter.getExpression2().evaluate(null, Boolean.class)) && (function = (DGGSSetFunction)filter.getExpression1()).isStable()) {
            Iterator<Zone> zones = function.getMatchedZones();
            return this.getFilterFrom(zones);
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            Geometry geometry = (Geometry)filter.getExpression2().evaluate(Geometry.class);
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                Iterator<Zone> zones = this.dggs.polygon(polygon, this.resolution, true);
                return DGGSFilterTransformer.getFilterFrom(this.dggs, zones, this.resolution);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Iterator<Zone>> iterators = new ArrayList<Iterator<Zone>>();
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                    iterators.add(this.dggs.polygon(polygon, this.resolution, true));
                }
                Iterator zones = IteratorUtils.chainedIterator((Iterator[])((Iterator[])iterators.toArray(Iterator[]::new)));
                return DGGSFilterTransformer.getFilterFrom(this.dggs, zones, this.resolution);
            }
        }
        return super.visit(filter, extraData);
    }

    public Object visit(BBOX filter, Object extraData) {
        ReferencedEnvelope envelope = ReferencedEnvelope.reference((Bounds)filter.getBounds());
        if (this.resolution == -1) {
            return super.visit(filter, extraData);
        }
        return DGGSFilterTransformer.getFilterFrom(this.dggs, this.dggs.zonesFromEnvelope((Envelope)envelope, this.resolution, true), this.resolution);
    }

    private Filter getFilterFrom(Iterator<Zone> zones) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(FF.property("zoneId"));
        while (zones.hasNext()) {
            expressions.add(FF.literal((Object)zones.next().getId()));
        }
        if (expressions.size() == 1) {
            return Filter.EXCLUDE;
        }
        Function inFunction = FF.function("in", expressions.toArray(new Expression[expressions.size()]));
        return FF.equal((Expression)inFunction, (Expression)FF.literal((Object)Boolean.TRUE), false);
    }

    public static Filter getFilterFrom(DGGSInstance dggs, Iterator<Zone> zones, int resolution) {
        ArrayList<Object> filters = new ArrayList<Object>();
        ArrayList<Object> inExpressions = new ArrayList<Object>();
        inExpressions.add(FF.property("zoneId"));
        while (zones.hasNext()) {
            Zone zone = zones.next();
            if (zone.getResolution() == resolution) {
                inExpressions.add(FF.literal((Object)zone.getId()));
                continue;
            }
            Filter childFilter = dggs.getChildFilter(FF, zone.getId(), resolution, false);
            filters.add(childFilter);
        }
        if (!filters.isEmpty()) {
            Or or = FF.or(new ArrayList(filters));
            filters.clear();
            filters.add(or);
        }
        if (inExpressions.size() > 1) {
            Function inFunction = FF.function("in", inExpressions.toArray(new Expression[inExpressions.size()]));
            PropertyIsEqualTo directChildMatches = FF.equal((Expression)inFunction, (Expression)FF.literal((Object)Boolean.TRUE), false);
            filters.add(directChildMatches);
        }
        PropertyIsEqualTo resolutionFilter = FF.equal((Expression)FF.property("resolution"), (Expression)FF.literal(resolution), true);
        if (filters.size() > 1) {
            return FF.and((Filter)FF.or(filters), (Filter)resolutionFilter);
        }
        if (filters.size() == 1) {
            return FF.and((Filter)filters.get(0), (Filter)resolutionFilter);
        }
        return Filter.EXCLUDE;
    }
}

