/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Literal;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunctionBase;
import org.geotools.dggs.Zone;

public class ParentsFunction
extends DGGSSetFunctionBase {
    Set<String> zoneIds;
    public static FunctionName NAME = ParentsFunction.functionName((String)"parents", (String)"result:Boolean", (String[])new String[]{"testedZoneId:String", "referenceZoneId:String", "dggs:org.geotools.dggs.DGGSInstance"});

    public ParentsFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String testedZoneId = (String)this.getParameterValue(object, 0);
        if (testedZoneId == null) {
            return false;
        }
        return this.matches(testedZoneId, () -> {
            String referenceZoneId = (String)this.getParameterValue(object, 1);
            DGGSInstance dggs = (DGGSInstance)this.getParameterValue(object, 2);
            if (referenceZoneId == null || dggs == null) {
                return Collections.emptyIterator();
            }
            return dggs.parents(referenceZoneId);
        });
    }

    @Override
    public void setDGGSInstance(DGGSInstance dggs) {
        Literal dggsLiteral = FF.literal((Object)dggs);
        List parameters = this.getParameters();
        if (parameters.size() == 2) {
            parameters.add(dggsLiteral);
        } else {
            parameters.set(2, dggsLiteral);
        }
        this.setParameters(parameters);
    }

    @Override
    public Iterator<Zone> getMatchedZones() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 2);
        return dggs.parents(referenceZoneId);
    }

    @Override
    public long countMatched() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 2);
        return dggs.countParents(referenceZoneId);
    }
}

