/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.gstore;

import java.io.IOException;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.dggs.DGGSFactoryFinder;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSGeometryStore;

public class DGGSGeometryStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DGGS_FACTORY_ID = new DataAccessFactory.Param("dggs_factory_id", String.class, "DGGS Factory identifier, e.g., H3 or rHEALPix", true, null);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        String factoryId = (String)DGGS_FACTORY_ID.lookUp(params);
        DGGSInstance instance = DGGSFactoryFinder.createInstance(factoryId, params);
        DGGSGeometryStore store = new DGGSGeometryStore(instance);
        String namespace = (String)NAMESPACE.lookUp(params);
        if (namespace != null) {
            store.setNamespaceURI(namespace);
        }
        return store;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.createDataStore(params);
    }

    public String getDisplayName() {
        return "DGGS Geometry Store";
    }

    public String getDescription() {
        return "Store returning DGGS zones, with no data associated (pure geometric description)";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{NAMESPACE, DGGS_FACTORY_ID};
    }

    public boolean isAvailable() {
        return DGGSFactoryFinder.getExtensionFactories().findFirst().isPresent();
    }
}

