/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.data.DataTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class CompositeBuilderTest
extends DataTestCase {
    @Test
    public void testCompositeNulls() throws Exception {
        NamespaceSupport ns = new NamespaceSupport();
        DynamicValueBuilder p1 = new DynamicValueBuilder("k1", "${notThere}", ns);
        DynamicValueBuilder p2 = new DynamicValueBuilder("k2", "$${strSubstring(notThereEither, 5, 10)}", ns);
        JSONObject json = this.buildComposite(ns, p1, p2);
        Assert.assertTrue((boolean)json.isEmpty());
    }

    @Test
    public void testCompositeOneKey() throws Exception {
        NamespaceSupport ns = new NamespaceSupport();
        DynamicValueBuilder p1 = new DynamicValueBuilder("k1", "${id}", ns);
        DynamicValueBuilder p2 = new DynamicValueBuilder("k2", "$${strToUpperCase(notThere)}", ns);
        JSONObject json = this.buildComposite(ns, p1, p2);
        Assert.assertFalse((boolean)json.isEmpty());
        Assert.assertEquals((long)1L, (long)json.size());
        JSONObject composite = json.getJSONObject("composite");
        Assert.assertEquals((Object)1, (Object)composite.get("k1"));
        Assert.assertFalse((boolean)json.has("k2"));
    }

    @Test
    public void testCompositeTwoKeys() throws Exception {
        NamespaceSupport ns = new NamespaceSupport();
        DynamicValueBuilder p1 = new DynamicValueBuilder("k1", "${id}", ns);
        DynamicValueBuilder p2 = new DynamicValueBuilder("k2", "$${strToUpperCase(name)}", ns);
        JSONObject json = this.buildComposite(ns, p1, p2);
        System.out.println(json.toString());
        Assert.assertFalse((boolean)json.isEmpty());
        Assert.assertEquals((long)1L, (long)json.size());
        JSONObject composite = json.getJSONObject("composite");
        Assert.assertEquals((Object)1, (Object)composite.get("k1"));
        Assert.assertEquals((Object)"R1", (Object)composite.get("k2"));
    }

    private JSONObject buildComposite(NamespaceSupport ns, DynamicValueBuilder p1, DynamicValueBuilder p2) throws IOException {
        CompositeBuilder composite = new CompositeBuilder("composite", ns, false);
        composite.addChild((TemplateBuilder)p1);
        composite.addChild((TemplateBuilder)p2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        writer.writeStartObject();
        composite.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)this.roadFeatures[0]));
        writer.writeEndObject();
        writer.close();
        String jsonString = new String(baos.toByteArray());
        return (JSONObject)JSONSerializer.toJSON((Object)jsonString);
    }
}

