/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import java.util.List;
import org.geoserver.featurestemplating.expressions.ListFunctionsTestSupport;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.junit.Assert;
import org.junit.Test;

public class AggregateFunctionTest
extends ListFunctionsTestSupport {
    @Test
    public void testAggregateMinFunction() {
        Expression aggregate = this.buildNumericAggregate("MIN");
        Object result = aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((Object)1.1, (Object)result);
    }

    @Test
    public void testAggregateMaxFunction() {
        Expression aggregate = this.buildNumericAggregate("MAX");
        Object result = aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((Object)9.9, (Object)result);
    }

    @Test
    public void testAggregateAvgFunction() {
        Expression aggregate = this.buildNumericAggregate("AVG");
        Object result = aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((double)6.6, (double)((Double)result), (double)1.0E-5);
    }

    @Test
    public void testAggregateUniqueFunction() {
        Expression aggregate = this.buildAggregate("UNIQUE", "dupProperty", "intValue > 3");
        List result = (List)aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"odd", result.get(0));
        Assert.assertEquals((Object)"even", result.get(1));
    }

    @Test
    public void testAggregateJoinFunction() {
        Expression aggregate = this.buildAggregate("JOIN(,)", "stringValue", "intValue < 6");
        Object result = aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((Object)"E,D,C,B,A", (Object)result);
    }

    @Test
    public void testAggregateJoinFunctionDefSep() {
        Expression aggregate = this.buildAggregate("JOIN", "stringValue", "intValue < 6");
        Object result = aggregate.evaluate((Object)this.featureList);
        Assert.assertEquals((Object)"E D C B A", (Object)result);
    }

    private Expression buildNumericAggregate(String aggrParam) {
        return this.buildAggregate(aggrParam, "doubleValue", "stringValue = \"A\" OR intValue >= 8 ");
    }

    private Expression buildAggregate(String aggrParam, String propertyName, String filter) {
        Function filtering = ff.function("filter", new Expression[]{ff.literal((Object)filter)});
        Function sort = ff.function("sort", new Expression[]{ff.literal((Object)"DESC")});
        PropertyName pn = ff.property(propertyName);
        Function stream = ff.function("stream", new Expression[]{filtering, pn, sort});
        Function aggregate = ff.function("aggregate", new Expression[]{stream, ff.literal((Object)aggrParam)});
        return aggregate;
    }
}

