/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.readers.GMLTemplateReader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class XmlTemplateReaderTest {
    FileSystemResourceStore store;

    @Before
    public void setupStore() {
        this.store = new FileSystemResourceStore(new File("src/test/resources/xmlincludes"));
    }

    @Test
    public void testFlatInclusion() throws IOException {
        GMLTemplateReader reader = new GMLTemplateReader(this.store.get("MappedFeatureIncludeFlat.xml"), new NamespaceSupport());
        RootBuilder rootBuilder = reader.getRootBuilder();
        TemplateBuilder mappedFeatureBuilder = (TemplateBuilder)((TemplateBuilder)((TemplateBuilder)rootBuilder.getChildren().get(0)).getChildren().get(0)).getChildren().get(0);
        TemplateBuilder specification = null;
        for (TemplateBuilder b : mappedFeatureBuilder.getChildren()) {
            if (!((AbstractTemplateBuilder)b).getKey(null).equals("gsml:specification")) continue;
            specification = b;
            break;
        }
        Assert.assertNotNull(specification);
        Assert.assertEquals((long)2L, (long)specification.getChildren().size());
        Assert.assertTrue((boolean)(specification.getChildren().get(1) instanceof StaticBuilder));
        AbstractTemplateBuilder geologicUnit = (AbstractTemplateBuilder)specification.getChildren().get(0);
        Assert.assertEquals((Object)"gsml:GeologicUnit", (Object)geologicUnit.getKey(null));
        Assert.assertEquals((long)4L, (long)geologicUnit.getChildren().size());
    }

    @Test
    public void testInlineInclusion() throws IOException {
        GMLTemplateReader reader = new GMLTemplateReader(this.store.get("MappedFeatureInclude.xml"), new NamespaceSupport());
        RootBuilder rootBuilder = reader.getRootBuilder();
        TemplateBuilder mappedFeatureBuilder = (TemplateBuilder)rootBuilder.getChildren().get(0);
        TemplateBuilder specification = null;
        for (TemplateBuilder b : mappedFeatureBuilder.getChildren()) {
            String key = ((AbstractTemplateBuilder)b).getKey(null);
            if (key == null || !key.equals("gsml:specification")) continue;
            specification = b;
            break;
        }
        Assert.assertNotNull(specification);
        AbstractTemplateBuilder geologicUnit = (AbstractTemplateBuilder)specification.getChildren().get(0);
        Assert.assertEquals((Object)"gsml:GeologicUnit", (Object)geologicUnit.getKey(null));
        Assert.assertTrue((geologicUnit.getChildren().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotExistingInclusion() {
        this.checkThrowingTemplate("MappedFeatureIncludeNotExisting.xml");
    }

    @Test
    public void testRecursiveInclusion() {
        RuntimeException ex = this.checkThrowingTemplate("ping.xml");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Went beyond maximum expansion depth (51), chain is: [ping.xml"));
    }

    @Test
    public void testIncludedModificationAreDetected() throws IOException, InterruptedException {
        GMLTemplateReader reader = new GMLTemplateReader(this.store.get("MappedFeatureIncludeFlat.xml"), new NamespaceSupport());
        RootBuilder rootBuilder = reader.getRootBuilder();
        Assert.assertFalse((boolean)rootBuilder.needsReload());
        File file = this.store.get("includedGeologicUnit.xml").file();
        file.setLastModified(new Date().getTime());
        for (int i = 0; i < 600; ++i) {
            if (rootBuilder.needsReload()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)"Should have found a reload 60 seconds, but did not");
    }

    private RuntimeException checkThrowingTemplate(String s) {
        return (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> new GMLTemplateReader(this.store.get(s), new NamespaceSupport()).getRootBuilder());
    }
}

