/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class TemplateComplexTestSupport
extends AbstractAppSchemaTestSupport {
    protected JSON getJsonLd(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)response.getContentType(), (Object)"application/ld+json");
        return this.json(response);
    }

    protected JSON postJsonLd(String path, String xml) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, xml);
        Assert.assertEquals((Object)response.getContentType(), (Object)"application/ld+json");
        return this.json(response);
    }

    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData();
    }

    protected JSON getJson(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String contentType = response.getContentType();
        if (contentType != null) {
            MatcherAssert.assertThat((Object)contentType, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"application/json"), CoreMatchers.equalTo((Object)"application/geo+json"), CoreMatchers.equalTo((Object)"application/json;charset=UTF-8")}));
        }
        return this.json(response);
    }

    protected JSON postJson(String path, String xml) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, xml);
        String contentType = response.getContentType();
        if (contentType != null) {
            Assert.assertEquals((Object)contentType, (Object)"application/json");
        }
        return this.json(response);
    }

    protected void checkAdditionalInfo(JSONObject result) {
        Assert.assertNotNull((Object)result.get("numberReturned"));
        Assert.assertNotNull((Object)result.get("timeStamp"));
        if (result.has("crs")) {
            JSONObject crs = result.getJSONObject("crs");
            JSONObject props = crs.getJSONObject("properties");
            Assert.assertNotNull((Object)props);
            Assert.assertNotNull((Object)props.getString("name"));
        }
        if (result.has("links")) {
            JSONArray links = result.getJSONArray("links");
            Assert.assertTrue((links.size() > 0 ? 1 : 0) != 0);
        }
    }

    protected void checkContext(Object context) {
        if (context instanceof JSONArray) {
            int size = ((JSONArray)context).size();
            Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        }
        if (context instanceof JSONObject) {
            Assert.assertFalse((boolean)((JSONObject)context).isEmpty());
        }
    }

    protected void setUpTemplate(String cqlRuleCondition, SupportedFormat outputFormat, String templateFileName, String templateName, String templateExtension, String workspace, FeatureTypeInfo ft) throws IOException {
        this.setUpTemplate(cqlRuleCondition, null, outputFormat, templateFileName, templateName, templateExtension, workspace, ft);
    }

    protected void setUpTemplate(String cqlRuleCondition, String profile, SupportedFormat outputFormat, String templateFileName, String templateName, String templateExtension, String workspace, FeatureTypeInfo ft) throws IOException {
        String rawTemplate = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(templateFileName), (Charset)Charsets.UTF_8);
        TemplateInfo info = new TemplateInfo();
        info.setExtension(templateExtension);
        info.setTemplateName(templateName);
        info.setWorkspace(workspace);
        info.setFeatureType(ft.getNativeName());
        TemplateInfoDAO.get().saveOrUpdate(info);
        TemplateFileManager.get().saveTemplateFile(info, rawTemplate);
        TemplateRule rule = new TemplateRule();
        rule.setTemplateName(info.getFullName());
        rule.setCqlFilter(cqlRuleCondition);
        rule.setProfileFilter(profile);
        rule.setOutputFormat(outputFormat);
        rule.setTemplateIdentifier(info.getIdentifier());
        TemplateRuleService ruleService = new TemplateRuleService(ft);
        ruleService.saveRule(rule);
    }

    protected void checkMappedFeatureJSON(JSONObject feature) {
        Assert.assertNotNull((Object)feature);
        String id = feature.getString("@id");
        Assert.assertNotNull((Object)id);
        JSONObject geom = (JSONObject)feature.get("geometry");
        Assert.assertNotNull((Object)geom);
        Assert.assertEquals((Object)String.valueOf(geom.get("@type")), (Object)"Polygon");
        Assert.assertNotNull((Object)geom.get("wkt"));
        this.checkSimpleArrayWithDynamicValues(feature);
        if ("mf5".equals(id)) {
            return;
        }
        JSONObject geologicUnit = feature.getJSONObject("gsml:GeologicUnit");
        String geologicUnitDescr = geologicUnit.getString("description");
        Assert.assertNotNull((Object)geologicUnitDescr);
        JSONArray composition = geologicUnit.getJSONArray("gsml:composition");
        Assert.assertTrue((composition.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < composition.size(); ++i) {
            JSONObject compositionObj = composition.getJSONObject(i);
            String previousContextEl = compositionObj.getString("previousContextValue");
            Assert.assertEquals((Object)geologicUnitDescr, (Object)previousContextEl);
            JSONArray compositionPart = (JSONArray)((JSONObject)composition.get(i)).get("gsml:compositionPart");
            Assert.assertTrue((compositionPart.size() > 0 ? 1 : 0) != 0);
            for (int j = 0; j < compositionPart.size(); ++j) {
                JSONObject role = compositionPart.getJSONObject(j).getJSONObject("gsml:role");
                Assert.assertNotNull((Object)role);
                JSONObject proportion = compositionPart.getJSONObject(j).getJSONObject("proportion");
                Assert.assertNotNull((Object)proportion);
                JSONArray lithology = (JSONArray)compositionPart.getJSONObject(j).get("lithology");
                Assert.assertTrue((lithology.size() > 0 ? 1 : 0) != 0);
            }
        }
    }

    protected void checkSimpleArrayWithDynamicValues(JSONObject feature) {
        JSONArray arrayWithDynamic = feature.getJSONObject("gsml:positionalAccuracy").getJSONArray("valueArray");
        String value = feature.getJSONObject("gsml:positionalAccuracy").getString("value");
        Assert.assertEquals((Object)value, (Object)arrayWithDynamic.getString(0));
        Assert.assertEquals((Object)"someStaticVal", (Object)arrayWithDynamic.getString(1));
        Assert.assertEquals((Object)("duplicated value: " + value), (Object)arrayWithDynamic.getString(2));
    }

    protected void checkInspireMappedFeature(JSONObject feature) {
        Assert.assertNotNull((Object)feature);
        String id = feature.getString("@id");
        Assert.assertNotNull((Object)id);
        JSONObject geom = (JSONObject)feature.get("geometry");
        Assert.assertNotNull((Object)geom);
        Assert.assertEquals((Object)String.valueOf(geom.get("type")), (Object)"Polygon");
        Assert.assertNotNull((Object)geom.get("coordinates"));
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertNotNull((Object)properties);
        Assert.assertNotNull((Object)properties.getString("name"));
        Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_description"));
        Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:geologicUnitType"));
        if (id.equals("mf1")) {
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_gsml:role_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_gsml:role_@codeSpace"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_CGI_TermValue_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_CGI_TermValue_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_name"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_vocabulary"));
        } else if (id.equals("mf2") || id.equals("mf3")) {
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_gsml:role_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_gsml:role_@codeSpace"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_proportion_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_proportion_CGI_TermValue_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_proportion_CGI_TermValue_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_lithology_name"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_1_gsml:compositionPart_lithology_vocabulary"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_gsml:role_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_gsml:role_@codeSpace"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_proportion_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_proportion_CGI_TermValue_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_proportion_CGI_TermValue_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_lithology_name"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_2_gsml:compositionPart_lithology_vocabulary"));
        } else if (id.equals("mf4")) {
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_gsml:role_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_gsml:role_@codeSpace"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_CGI_TermValue_@dataType"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_proportion_CGI_TermValue_value"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_1_name_1"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_1_name_2"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_1_name_3"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_1_vocabulary"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_2_name"));
            Assert.assertNotNull((Object)properties.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_2_vocabulary"));
        }
    }

    protected void checkMappedFeatureGeoJSON(JSONObject feature) {
        Assert.assertNotNull((Object)feature);
        String id = feature.getString("@id");
        Assert.assertNotNull((Object)id);
        JSONObject geom = (JSONObject)feature.get("geometry");
        Assert.assertNotNull((Object)geom);
        Assert.assertEquals((Object)String.valueOf(geom.get("type")), (Object)"Polygon");
        Assert.assertNotNull((Object)geom.get("coordinates"));
        if ("mf5".equals(id)) {
            return;
        }
        JSONObject geologicUnit = feature.getJSONObject("gsml:GeologicUnit");
        JSONArray composition = geologicUnit.getJSONArray("gsml:composition");
        Assert.assertTrue((composition.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < composition.size(); ++i) {
            JSONArray compositionPart = (JSONArray)((JSONObject)composition.get(i)).get("gsml:compositionPart");
            Assert.assertTrue((compositionPart.size() > 0 ? 1 : 0) != 0);
            for (int j = 0; j < compositionPart.size(); ++j) {
                JSONObject role = compositionPart.getJSONObject(j).getJSONObject("gsml:role");
                Assert.assertNotNull((Object)role);
                JSONObject proportion = compositionPart.getJSONObject(j).getJSONObject("proportion");
                Assert.assertNotNull((Object)proportion);
                JSONArray lithology = (JSONArray)compositionPart.getJSONObject(j).get("lithology");
                Assert.assertTrue((lithology.size() > 0 ? 1 : 0) != 0);
            }
        }
    }
}

