/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.junit.Assert;
import org.junit.Test;

public class JSONLDWriterTest {
    @Test
    public void testJSONRootAttributesCollNameCustomization() throws IOException {
        EncodingHints encodingHints = new EncodingHints();
        encodingHints.put((Object)"collection_name", (Object)"diseaseSpreadStatistics");
        JSONObject json = this.writeJSONLD(encodingHints);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.getString("@type"));
        Assert.assertTrue((boolean)json.has("diseaseSpreadStatistics"));
        Assert.assertFalse((boolean)json.has("features"));
    }

    @Test
    public void testJSONRootAttributesTypeCustomization() throws IOException {
        EncodingHints encodingHints = new EncodingHints();
        encodingHints.put((Object)"@type", (Object)"schema:PublicAnnouncement");
        JSONObject json = this.writeJSONLD(encodingHints);
        Assert.assertEquals((Object)"schema:PublicAnnouncement", (Object)json.getString("@type"));
        Assert.assertTrue((boolean)json.has("features"));
    }

    @Test
    public void testJSONRootAttributesFullCustomization() throws IOException {
        EncodingHints encodingHints = new EncodingHints();
        encodingHints.put((Object)"@type", (Object)"schema:PublicAnnouncement");
        encodingHints.put((Object)"collection_name", (Object)"diseaseSpreadStatistics");
        JSONObject json = this.writeJSONLD(encodingHints);
        Assert.assertEquals((Object)"schema:PublicAnnouncement", (Object)json.getString("@type"));
        Assert.assertTrue((boolean)json.has("diseaseSpreadStatistics"));
        Assert.assertFalse((boolean)json.has("features"));
    }

    @Test
    public void testJSONRootAttributesDefault() throws IOException {
        EncodingHints encodingHints = new EncodingHints();
        JSONObject json = this.writeJSONLD(encodingHints);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.getString("@type"));
        Assert.assertTrue((boolean)json.has("features"));
    }

    private JSONObject writeJSONLD(EncodingHints hints) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JSONLDWriter writer = new JSONLDWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8));
        writer.startTemplateOutput(hints);
        writer.endTemplateOutput(hints);
        writer.close();
        String rawJSON = new String(baos.toByteArray(), Charset.forName("UTF-8"));
        return (JSONObject)JSONSerializer.toJSON((Object)rawJSON);
    }
}

