/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.flat;

import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geotools.api.filter.expression.Expression;

class AttributeNameHelper {
    private Expression key;
    private String parentKey;
    private String separator;
    static final String PROPERTIES_KEY = "properties";

    AttributeNameHelper(Expression key, String separator) {
        this.key = key;
        this.separator = separator;
    }

    String getFinalAttributeName(TemplateBuilderContext context) {
        Object key;
        String parentKey = this.parentKey;
        Object object = key = this.key != null ? this.key.evaluate(context.getCurrentObj()).toString() : null;
        if (parentKey != null && !parentKey.equals(PROPERTIES_KEY) && key != null) {
            key = parentKey + this.separator + (String)key;
        } else if (key == null) {
            key = parentKey;
        }
        if (this.separator != "_" && key != null) {
            key = this.replaceDefaultSeparatorWithCustom((String)key, this.separator);
        }
        return key;
    }

    String getCompleteCompositeAttributeName() {
        Object key;
        String parentKey = this.parentKey;
        Object object = key = this.key != null ? this.key.evaluate(null).toString() : null;
        if (parentKey != null && !parentKey.equals(PROPERTIES_KEY)) {
            if (key != null && !((String)key).equals(PROPERTIES_KEY)) {
                key = parentKey + this.separator + (String)key;
            } else if (key == null || ((String)key).equals(PROPERTIES_KEY)) {
                key = parentKey;
            }
        }
        if (this.separator != "_" && key != null) {
            key = this.replaceDefaultSeparatorWithCustom((String)key, this.separator);
        }
        return key;
    }

    String getCompleteIteratingAttributeName(int elementsSize, int index) {
        Object key = this.key != null ? this.key.evaluate(null).toString() : null;
        String parentKey = this.parentKey;
        if (parentKey != null && !parentKey.equals(PROPERTIES_KEY)) {
            key = parentKey + this.separator + (String)key;
        }
        key = this.replaceDefaultSeparatorWithCustom((String)key, this.separator);
        Object itKey = elementsSize > 0 ? (String)key + this.separator + index : key;
        return itKey;
    }

    private String replaceDefaultSeparatorWithCustom(String key, String separator) {
        char[] charArr = key.toCharArray();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < charArr.length; ++i) {
            char next = ' ';
            char curr = charArr[i];
            if (curr == '_') {
                if (i < charArr.length - 1) {
                    next = charArr[i + 1];
                }
                if (!Character.isDigit(next)) {
                    sb.append(separator);
                    continue;
                }
                sb.append(curr);
                continue;
            }
            sb.append(curr);
        }
        return sb.toString();
    }

    void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public String getSeparator() {
        return this.separator;
    }
}

