/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.flat;

import java.io.IOException;
import org.geoserver.featurestemplating.builders.flat.AttributeNameHelper;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class FlatDynamicBuilder
extends DynamicValueBuilder
implements FlatBuilder {
    private AttributeNameHelper nameHelper;

    public FlatDynamicBuilder(String key, String expression, NamespaceSupport namespaces, String separator) {
        super(key, expression, namespaces);
        this.nameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatDynamicBuilder(FlatDynamicBuilder builder, boolean includeChildren) {
        super(builder, includeChildren);
        this.nameHelper = new AttributeNameHelper(this.key, builder.nameHelper.getSeparator());
    }

    @Override
    protected void writeValue(TemplateOutputWriter writer, Object value, TemplateBuilderContext context) throws IOException {
        writer.writeElementNameAndValue(this.nameHelper.getFinalAttributeName(context), value, this.getEncodingHints());
    }

    @Override
    public void setParentKey(String parentKey) {
        this.nameHelper.setParentKey(parentKey);
    }

    @Override
    public FlatDynamicBuilder copy(boolean includeChildren) {
        return new FlatDynamicBuilder(this, includeChildren);
    }
}

