/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class CompositeBuilder
extends SourceBuilder {
    public CompositeBuilder(String key, NamespaceSupport namespaces, boolean topLevelComplex) {
        super(key, namespaces, topLevelComplex);
    }

    public CompositeBuilder(CompositeBuilder compositeBuilder, boolean includeChildren) {
        super(compositeBuilder, includeChildren);
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        this.addSkipObjectEncodingHint(context);
        context = this.evaluateSource(context);
        Object o = context.getCurrentObj();
        if (o != null && this.evaluateFilter(context) && this.canWrite(context)) {
            this.evaluateChildren(writer, context);
        }
    }

    protected void evaluateChildren(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.ownOutput) {
            writer.startObject(this.getKey(context), this.encodingHints);
        }
        for (TemplateBuilder jb : this.children) {
            jb.evaluate(writer, context);
        }
        if (this.ownOutput) {
            writer.endObject(this.getKey(context), this.encodingHints);
        }
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        List filtered = this.children.stream().filter(b -> b instanceof DynamicValueBuilder || b instanceof SourceBuilder).collect(Collectors.toList());
        if (filtered.size() == this.children.size()) {
            int falseCounter = 0;
            for (TemplateBuilder b2 : filtered) {
                if (!(b2 instanceof AbstractTemplateBuilder) || ((AbstractTemplateBuilder)b2).canWrite(context)) continue;
                ++falseCounter;
            }
            if (falseCounter == filtered.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public CompositeBuilder copy(boolean includeChildren) {
        return new CompositeBuilder(this, includeChildren);
    }

    @Override
    public Object accept(TemplateVisitor visitor, Object value) {
        return visitor.visit(this, value);
    }
}

