/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.featurestemplating.expressions.XpathFunction;
import org.geoserver.featurestemplating.expressions.aggregate.StringCQLFunction;
import org.geoserver.util.XCQL;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.xml.sax.helpers.NamespaceSupport;

public class TemplateCQLManager {
    private String strCql;
    private int contextPos = 0;
    private NamespaceSupport namespaces;
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final String XPATH_FUN_START = "xpath(";
    public static final String PROPERTY_FUN_START = "propertyPath(";

    public TemplateCQLManager(String strCql, NamespaceSupport namespaces) {
        this.strCql = strCql;
        this.namespaces = namespaces;
    }

    public AttributeExpressionImpl getAttributeExpressionFromString() {
        String property = this.extractProperty(this.strCql);
        if (property.indexOf(".") != -1 && property.indexOf("/") == -1) {
            property = this.replaceDotSeparatorWithSlash(property);
        }
        this.contextPos = TemplateCQLManager.determineContextPos(property);
        if ((property = TemplateCQLManager.removeBackDots(property)).indexOf(".") != -1) {
            property = property.replaceAll("\\.", "/");
        }
        return new AttributeExpressionImpl(property, this.namespaces);
    }

    public Expression getExpressionFromString() {
        String strPropertyNameFun = this.extractPropertyNameFunction(this.strCql);
        String propertyWithSlash = this.replaceDotSeparatorWithSlashInFunction(strPropertyNameFun);
        if (this.containsAPropertyNameFunction(propertyWithSlash)) {
            this.contextPos = TemplateCQLManager.determineContextPos(propertyWithSlash);
        }
        String literalXpath = TemplateCQLManager.removeBackDots(propertyWithSlash);
        Expression cql = this.extractCqlExpressions(this.cleanCQL(this.strCql, strPropertyNameFun, literalXpath));
        TemplatingExpressionVisitor visitor = new TemplatingExpressionVisitor();
        cql.accept((ExpressionVisitor)visitor, null);
        return cql;
    }

    public Filter getFilterFromString() throws CQLException {
        String propertyNameFun = this.extractPropertyNameFunction(this.strCql);
        String propertyWithSlash = this.replaceDotSeparatorWithSlashInFunction(propertyNameFun);
        if (this.containsAPropertyNameFunction(propertyWithSlash)) {
            this.contextPos = TemplateCQLManager.determineContextPos(propertyWithSlash);
        }
        String literalPn = TemplateCQLManager.removeBackDots(propertyWithSlash);
        String cleanedCql = this.cleanCQL(this.strCql, propertyNameFun, literalPn);
        Filter templateFilter = XCQL.toFilter((String)cleanedCql);
        TemplatingExpressionVisitor visitor = new TemplatingExpressionVisitor();
        return (Filter)templateFilter.accept((FilterVisitor)visitor, null);
    }

    private Object setPropertyNameToCQL(Object cql, final String xpath) {
        DuplicatingFilterVisitor filterVisitor = new DuplicatingFilterVisitor(){

            public Object visit(Literal expression, Object extraData) {
                String strVal;
                if (expression.getValue() instanceof String && (strVal = (String)expression.getValue()).endsWith(xpath)) {
                    return new AttributeExpressionImpl(xpath, TemplateCQLManager.this.namespaces);
                }
                return super.visit(expression, extraData);
            }
        };
        Object result = cql instanceof Expression ? ((Expression)cql).accept((ExpressionVisitor)filterVisitor, null) : ((Filter)cql).accept((FilterVisitor)filterVisitor, null);
        return result;
    }

    private String extractProperty(String property) {
        boolean inXpath = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < property.length(); ++i) {
            char next;
            char curr = property.charAt(i);
            boolean isLast = i == property.length() - 1;
            char c = next = isLast ? (char)'\u0000' : property.charAt(i + 1);
            if (curr == '\\') {
                if (isLast) {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                if (next == '\\') {
                    sb.append('\\');
                } else if (next == '$') {
                    sb.append('$');
                } else if (next == '}') {
                    sb.append('}');
                } else {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                ++i;
                continue;
            }
            if (curr == '$') {
                if (isLast || next != '{') {
                    throw new IllegalArgumentException("Unescaped $ at position " + (i + 1));
                }
                if (inXpath) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                inXpath = true;
                ++i;
                continue;
            }
            if (curr == '}') {
                if (!inXpath) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() != 0) continue;
                throw new IllegalArgumentException("Invalid empty cql expression ${} at " + (i - 1));
            }
            sb.append(curr);
        }
        return sb.toString();
    }

    private List<Expression> splitCqlExpressions(String expression) {
        boolean inCqlExpression = false;
        ArrayList<Expression> result = new ArrayList<Expression>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            int prev;
            char curr = expression.charAt(i);
            boolean isLast = i == expression.length() - 1;
            char next = isLast ? (char)'\u0000' : expression.charAt(i + 1);
            int n = prev = i > 0 ? (int)expression.charAt(i - 1) : 32;
            if (curr == '\\') {
                if (isLast) {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                if (next == '\\') {
                    sb.append('\\');
                } else if (next == '$') {
                    sb.append('$');
                } else if (next == '}') {
                    sb.append('}');
                } else {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                ++i;
                continue;
            }
            if (curr == '$' && prev != 36) {
                if (isLast || next != '$') {
                    throw new IllegalArgumentException("Unescaped $ at position " + (i + 1));
                }
                if (inCqlExpression) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() > 0) {
                    result.add((Expression)ff.literal((Object)sb.toString()));
                    sb.setLength(0);
                }
                ++i;
                continue;
            }
            if (curr == '$' && prev == 36) {
                if (isLast || next != '{') {
                    throw new IllegalArgumentException("Unescaped $ at position " + (i + 1));
                }
                if (inCqlExpression) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() > 0) {
                    result.add((Expression)ff.literal((Object)sb.toString()));
                    sb.setLength(0);
                }
                inCqlExpression = true;
                ++i;
                continue;
            }
            if (curr == '}') {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException("Invalid empty cql expression ${} at " + (i - 1));
                }
                try {
                    Expression parsed = ECQL.toExpression((String)sb.toString());
                    TemplatingExpressionVisitor visitor = new TemplatingExpressionVisitor();
                    Expression namespaced = (Expression)parsed.accept((ExpressionVisitor)visitor, null);
                    result.add(namespaced);
                    sb.setLength(0);
                }
                catch (CQLException e) {
                    throw new IllegalArgumentException("Invalid cql expression '" + sb + "'", e);
                }
                inCqlExpression = false;
                continue;
            }
            if (curr == '{') continue;
            sb.append(curr);
        }
        if (inCqlExpression) {
            throw new IllegalArgumentException("Unclosed CQL expression '" + sb + "'");
        }
        if (sb.length() > 0) {
            result.add((Expression)ff.literal((Object)sb.toString()));
        }
        return result;
    }

    private Expression catenateExpressions(List<Expression> expressions) {
        if (expressions == null || expressions.size() == 0) {
            throw new IllegalArgumentException("You should provide at least one expression in the list");
        }
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return ff.function("Concatenate", expressions.toArray(new Expression[0]));
    }

    private Expression extractCqlExpressions(String expression) {
        return this.catenateExpressions(this.splitCqlExpressions(expression));
    }

    private String cleanCQL(String cql, String toReplace, String replacement) {
        if (this.containsAPropertyNameFunction(cql)) {
            cql = cql.replace(toReplace, replacement).replaceAll("\\.\\./", "");
        }
        return cql;
    }

    public static String removeBackDots(String xpath) {
        if (xpath.indexOf("../") != -1) {
            return xpath.replaceAll("\\.\\./", "");
        }
        return xpath;
    }

    private String extractPropertyNameFunction(String expression) {
        int propertyI = expression.indexOf(XPATH_FUN_START);
        if (propertyI == -1) {
            propertyI = expression.indexOf(PROPERTY_FUN_START);
        }
        if (propertyI != -1) {
            int propertyI2 = expression.indexOf(")", propertyI);
            String strProperty = expression.substring(propertyI, propertyI2 + 1);
            return strProperty;
        }
        return expression;
    }

    private String toLiteralXpath(String strXpath) {
        if (strXpath.indexOf(XPATH_FUN_START) != -1) {
            return strXpath.replace(XPATH_FUN_START, "").replace(")", "");
        }
        return strXpath;
    }

    public static int determineContextPos(String xpath) {
        int contextPos = 0;
        while (xpath.contains("../")) {
            ++contextPos;
            xpath = xpath.replaceFirst("\\.\\./", "");
        }
        return contextPos;
    }

    public int getContextPos() {
        return this.contextPos;
    }

    public static String quoteXpathAttribute(String xpath) {
        int atIndex = xpath.indexOf("@");
        int quotedAtIndex = xpath.indexOf("\"@\"");
        if (atIndex != -1 && quotedAtIndex == -1) {
            char current;
            Matcher matcher;
            Pattern pattern = Pattern.compile("[a-zA-Z()<>.\\-1-9*]");
            String substring = xpath.substring(atIndex + 1);
            StringBuilder xpathAttribute = new StringBuilder("@");
            for (int i = 0; i < substring.length() && (matcher = pattern.matcher(String.valueOf(current = substring.charAt(i)))).matches(); ++i) {
                xpathAttribute.append(current);
            }
            return xpath.replaceAll(xpathAttribute.toString(), "\"" + xpathAttribute.toString() + "\"");
        }
        return xpath;
    }

    public Expression getThis() {
        return ff.function("xpath", new Expression[]{ff.literal((Object)".")});
    }

    private String replaceDotSeparatorWithSlashInFunction(String propertyName) {
        if (propertyName.indexOf(PROPERTY_FUN_START) != -1 && propertyName.indexOf(".") != -1 && propertyName.indexOf("/") == -1) {
            propertyName = propertyName.replaceAll(" ", "");
            int startPath = propertyName.indexOf(PROPERTY_FUN_START) + "propertyPath('".length();
            int endPath = propertyName.lastIndexOf("')");
            String content = propertyName.substring(startPath, endPath);
            String replaced = this.replaceDotSeparatorWithSlash(content);
            propertyName = propertyName.replace(content, replaced);
        }
        return propertyName;
    }

    private String replaceDotSeparatorWithSlash(String propertyName) {
        char[] chars = propertyName.toCharArray();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < chars.length; ++i) {
            char current = chars[i];
            int prev = 32;
            int next = 32;
            if (i > 0) {
                prev = chars[i - 1];
            }
            if (i < chars.length - 1) {
                next = chars[i + 1];
            }
            if (current == '.') {
                if ((i + 1) % 3 == 0 || prev != 46 && next != 46) {
                    sb.append("/");
                    continue;
                }
                sb.append(current);
                continue;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private boolean containsAPropertyNameFunction(String cql) {
        return cql.indexOf(XPATH_FUN_START) != -1 || cql.indexOf(PROPERTY_FUN_START) != -1;
    }

    private final class TemplatingExpressionVisitor
    extends DuplicatingFilterVisitor {
        private TemplatingExpressionVisitor() {
        }

        public Object visit(PropertyName expression, Object extraData) {
            if (expression instanceof XpathFunction) {
                XpathFunction f = (XpathFunction)((Object)this.visit((Function)expression, extraData));
                f.setNamespaceContext(TemplateCQLManager.this.namespaces);
                return f;
            }
            return this.getFactory(extraData).property(expression.getPropertyName(), TemplateCQLManager.this.namespaces);
        }

        public Object visit(Function expression, Object extraData) {
            if (expression instanceof StringCQLFunction) {
                StringCQLFunction function = (StringCQLFunction)expression;
                function.setNamespaceSupport(TemplateCQLManager.this.namespaces);
            }
            return super.visit(expression, extraData);
        }
    }
}

