/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;

public class RecursiveTemplateResourceParser {
    protected RecursiveTemplateResourceParser parent;
    protected Resource resource;
    private List<FileWatcher<Object>> watchers;
    protected static final int MAX_RECURSION_DEPTH = Integer.parseInt(System.getProperty("GEOSERVER_FT_MAX_DEPTH", "50"));

    public RecursiveTemplateResourceParser(Resource resource, RecursiveTemplateResourceParser parent) {
        this.resource = resource;
        this.validateResource(resource);
        this.parent = parent;
        this.watchers = parent.getWatchers();
        this.validateDepth();
        this.addFileWatcher(resource);
    }

    public RecursiveTemplateResourceParser(Resource resource) {
        this.resource = resource;
        this.validateResource(resource);
        this.parent = null;
        this.addFileWatcher(resource);
    }

    protected void validateResource(Resource resource) {
        if (!resource.getType().equals((Object)Resource.Type.RESOURCE)) {
            throw new IllegalArgumentException("Path " + resource.path() + " does not exist");
        }
    }

    protected List<String> getExpansionChain() {
        ArrayList<String> resources = new ArrayList<String>();
        RecursiveTemplateResourceParser curr = this;
        while (curr != null) {
            resources.add(curr.resource.path());
            curr = curr.parent;
        }
        Collections.reverse(resources);
        return resources;
    }

    protected int getDepth() {
        int depth = 0;
        RecursiveTemplateResourceParser curr = this.parent;
        while (curr != null) {
            curr = curr.parent;
            ++depth;
        }
        return depth;
    }

    protected Resource getResource(Resource resource, String path) {
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if (path.startsWith("/")) {
            return this.getRoot(resource).get(path);
        }
        return resource.parent().get(path);
    }

    private Resource getRoot(Resource resource) {
        Resource r = resource;
        Resource parent = r.parent();
        while (parent != null && !parent.equals(r)) {
            r = parent;
            parent = r.parent();
        }
        return r;
    }

    protected void validateDepth() {
        int depth = this.getDepth();
        if (depth > MAX_RECURSION_DEPTH) {
            throw new RuntimeException("Went beyond maximum expansion depth (" + depth + "), chain is: " + this.getExpansionChain());
        }
    }

    private void addFileWatcher(Resource resource) {
        if (this.watchers == null) {
            this.watchers = new ArrayList<FileWatcher<Object>>();
        }
        this.watchers.add(new IncludedTemplateWatcher(resource));
    }

    public List<FileWatcher<Object>> getWatchers() {
        return this.watchers;
    }

    private class IncludedTemplateWatcher
    extends FileWatcher<Object> {
        private IncludedTemplateWatcher(Resource resource) {
            super(resource);
        }

        public boolean isModified() {
            boolean result = false;
            if (this.lastModified != Long.MIN_VALUE) {
                result = super.isModified();
            } else {
                long lastCheck;
                this.lastCheck = lastCheck = System.currentTimeMillis();
                this.lastModified = lastCheck;
            }
            return result;
        }
    }
}

